/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerVariable;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServersImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AsyncApiEndpointMapper {
    public static final AsyncApiEndpointMapper ENDPOINT_MAPPER = new AsyncApiEndpointMapper();

    public AsyncApi25DocumentImpl getServers(AsyncApi25DocumentImpl asyncAPI, List<ListenerDeclarationNode> endpoints, ServiceDeclarationNode service) {
        List<AsyncApi25ServerImpl> servers = this.extractServerForExpressionNode((SeparatedNodeList<ExpressionNode>)service.expressions(), service);
        if (!endpoints.isEmpty()) {
            for (ListenerDeclarationNode ep : endpoints) {
                SeparatedNodeList exprNodes = service.expressions();
                for (ExpressionNode node : exprNodes) {
                    if (!node.toString().trim().equals(ep.variableName().text().trim())) continue;
                    String serviceBasePath = this.getServiceBasePath(service);
                    AsyncApi25ServerImpl server = this.extractServer(ep, serviceBasePath);
                    servers.add(server);
                }
            }
        }
        AsyncApi25ServersImpl asyncApi25Servers = new AsyncApi25ServersImpl();
        if (servers.size() > 1) {
            AsyncApi25ServerImpl mainServer = this.addEnumValues(servers);
            asyncApi25Servers.addItem("development", mainServer);
        } else {
            asyncApi25Servers.addItem("development", servers.get(0));
        }
        asyncAPI.setServers(asyncApi25Servers);
        return asyncAPI;
    }

    private AsyncApi25ServerImpl addEnumValues(List<AsyncApi25ServerImpl> servers) {
        AsyncApi25ServerImpl mainServer = servers.get(0);
        ArrayList<AsyncApi25ServerImpl> rotated = new ArrayList<AsyncApi25ServerImpl>(servers);
        Map<String, ServerVariable> mainVariable = mainServer.getVariables();
        ServerVariable hostVariable = mainVariable.get("server");
        ServerVariable portVariable = mainVariable.get("port");
        if (servers.size() > 1) {
            Collections.rotate(rotated, servers.size() - 1);
            for (AsyncApi25ServerImpl server : rotated) {
                Map<String, ServerVariable> variables = server.getVariables();
                this.setServerVariables(hostVariable, variables, "server");
                this.setServerVariables(portVariable, variables, "port");
            }
        }
        return mainServer;
    }

    private void setServerVariables(ServerVariable variable, Map<String, ServerVariable> variables, String variableName) {
        if (variables.get(variableName) != null) {
            List<String> hostVariableEnum = variable.getEnum();
            if (hostVariableEnum == null) {
                hostVariableEnum = new ArrayList<String>();
            }
            hostVariableEnum.add(variables.get(variableName).getDefault());
            variable.setEnum(hostVariableEnum);
        }
    }

    private AsyncApi25ServerImpl extractServer(ListenerDeclarationNode ep, String serviceBasePath) {
        Optional<ParenthesizedArgList> list;
        if (ep.initializer().kind() == SyntaxKind.CHECK_EXPRESSION) {
            ExpressionNode expression = ((CheckExpressionNode)ep.initializer()).expression();
            list = this.extractListenerNodeType((Node)expression);
        } else {
            list = this.extractListenerNodeType(ep.initializer());
        }
        return this.generateServer(serviceBasePath, list);
    }

    private Optional<ParenthesizedArgList> extractListenerNodeType(Node expression2) {
        Optional list = Optional.empty();
        if (expression2.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            ExplicitNewExpressionNode bTypeExplicit = (ExplicitNewExpressionNode)expression2;
            list = Optional.ofNullable(bTypeExplicit.parenthesizedArgList());
        } else if (expression2.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            ImplicitNewExpressionNode bTypeInit = (ImplicitNewExpressionNode)expression2;
            list = bTypeInit.parenthesizedArgList();
        }
        return list;
    }

    private List<AsyncApi25ServerImpl> extractServerForExpressionNode(SeparatedNodeList<ExpressionNode> bTypeExplicit, ServiceDeclarationNode service) {
        String serviceBasePath = this.getServiceBasePath(service);
        ArrayList<AsyncApi25ServerImpl> asyncApi25Servers = new ArrayList<AsyncApi25ServerImpl>();
        for (ExpressionNode expressionNode : bTypeExplicit) {
            if (!expressionNode.kind().equals((Object)SyntaxKind.EXPLICIT_NEW_EXPRESSION)) continue;
            ExplicitNewExpressionNode explicit = (ExplicitNewExpressionNode)expressionNode;
            Optional<ParenthesizedArgList> list = Optional.ofNullable(explicit.parenthesizedArgList());
            AsyncApi25ServerImpl server = this.generateServer(serviceBasePath, list);
            asyncApi25Servers.add(server);
        }
        return asyncApi25Servers;
    }

    private AsyncApi25ServerImpl generateServer(String serviceBasePath, Optional<ParenthesizedArgList> list) {
        String port = null;
        String host = null;
        String secured = "false";
        AsyncApi25ServerImpl server = new AsyncApi25ServerImpl();
        if (list.isPresent()) {
            ExpressionNode bLangRecordLiteral;
            SeparatedNodeList arg = list.get().arguments();
            port = ((FunctionArgumentNode)arg.get(0)).toString().trim().replaceAll("\"", "");
            if (arg.size() > 1 && arg.get(1) instanceof NamedArgumentNode && (bLangRecordLiteral = ((NamedArgumentNode)arg.get(1)).expression()) instanceof MappingConstructorExpressionNode) {
                ArrayList<String> extractedValues = this.extractHostAndCheckSecured((MappingConstructorExpressionNode)bLangRecordLiteral);
                host = extractedValues.get(0);
                secured = extractedValues.get(1);
            }
        }
        server.setProtocol("ws");
        server.setProtocolVersion("13");
        this.setServerVariableValues(serviceBasePath, port, host, secured, server);
        return server;
    }

    private void setServerVariableValues(String serviceBasePath, String port, String host, String secured, AsyncApi25ServerImpl server) {
        if (host != null && port != null) {
            AsyncApi25ServerVariable serverUrlVariable = server.createServerVariable();
            if (secured.equals("true")) {
                serverUrlVariable.setDefault("wss://" + host);
            } else {
                serverUrlVariable.setDefault("ws://" + host);
            }
            AsyncApi25ServerVariable portVariable = server.createServerVariable();
            portVariable.setDefault(port);
            server.addVariable("server", serverUrlVariable);
            server.addVariable("port", portVariable);
            String serverUrl = String.format("{server}:{port}%s", serviceBasePath);
            server.setUrl(serverUrl);
        } else if (host != null) {
            AsyncApi25ServerVariable serverUrlVariable = server.createServerVariable();
            serverUrlVariable.setDefault(host);
            server.addVariable("server", serverUrlVariable);
            String serverUrl = "{server}" + serviceBasePath;
            server.setUrl(serverUrl);
        } else if (port != null) {
            AsyncApi25ServerVariable serverUrlVariable = server.createServerVariable();
            if (secured.equals("true")) {
                serverUrlVariable.setDefault("wss://localhost");
            } else {
                serverUrlVariable.setDefault("ws://localhost");
            }
            AsyncApi25ServerVariable portVariable = server.createServerVariable();
            portVariable.setDefault(port);
            server.addVariable("server", serverUrlVariable);
            server.addVariable("port", portVariable);
            String serverUrl = "{server}:{port}" + serviceBasePath;
            server.setUrl(serverUrl);
        }
    }

    private ArrayList<String> extractHostAndCheckSecured(MappingConstructorExpressionNode bLangRecordLiteral) {
        ArrayList<String> returnValues = new ArrayList<String>();
        String host = null;
        String secured = "false";
        if (bLangRecordLiteral.fields() != null && !bLangRecordLiteral.fields().isEmpty()) {
            SeparatedNodeList recordFields = bLangRecordLiteral.fields();
            for (MappingFieldNode filed : recordFields) {
                if (!(filed instanceof SpecificFieldNode)) continue;
                Node fieldNode = ((SpecificFieldNode)filed).fieldName();
                String fieldName = ConverterCommonUtils.unescapeIdentifier(fieldNode.toString().trim());
                if (fieldName.trim().equals("host")) {
                    if (!((SpecificFieldNode)filed).valueExpr().isPresent()) continue;
                    host = ((ExpressionNode)((SpecificFieldNode)filed).valueExpr().get()).toString().trim();
                    continue;
                }
                if (!fieldName.trim().equals("secureSocket")) continue;
                secured = "true";
            }
        }
        if (host != null) {
            host = host.replaceAll("\"", "");
        }
        returnValues.add(host);
        returnValues.add(secured);
        return returnValues;
    }

    public String getServiceBasePath(ServiceDeclarationNode serviceDefinition) {
        StringBuilder currentServiceName = new StringBuilder();
        NodeList serviceNameNodes = serviceDefinition.absoluteResourcePath();
        for (Node serviceBasedPathNode : serviceNameNodes) {
            currentServiceName.append(ConverterCommonUtils.unescapeIdentifier(serviceBasedPathNode.toString()));
        }
        return currentServiceName.toString().trim();
    }
}

