/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25BindingImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelBindingsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelItemImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ParameterImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ParametersImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiComponentMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiHeaderMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiQueryParameterMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Map;
import java.util.NoSuchElementException;

public class AsyncApiParameterMapper {
    private final FunctionDefinitionNode functionDefinitionNode;
    private final Map<String, String> apidocs;
    private final AsyncApi25ComponentsImpl components;
    private final SemanticModel semanticModel;

    public AsyncApiParameterMapper(FunctionDefinitionNode functionDefinitionNode, Map<String, String> apidocs, AsyncApi25ComponentsImpl components, SemanticModel semanticModel) {
        this.functionDefinitionNode = functionDefinitionNode;
        this.apidocs = apidocs;
        this.components = components;
        this.semanticModel = semanticModel;
    }

    public void getResourceInputs(AsyncApi25ChannelItemImpl channelItem) {
        FunctionSignatureNode functionSignature;
        SeparatedNodeList parameterList;
        AsyncApi25ParametersImpl pathParameters;
        NodeList pathParams = this.functionDefinitionNode.relativeResourcePath();
        if (!pathParams.isEmpty() && !(pathParameters = this.createPathParameters((NodeList<Node>)pathParams)).getItems().isEmpty()) {
            channelItem.setParameters(pathParameters);
        }
        if (!(parameterList = (functionSignature = this.functionDefinitionNode.functionSignature()).parameters()).isEmpty()) {
            channelItem.setBindings(this.createQueryParameters((SeparatedNodeList<ParameterNode>)parameterList));
        }
    }

    private AsyncApi25ChannelBindingsImpl createQueryParameters(SeparatedNodeList<ParameterNode> parameterList) {
        AsyncApi25ChannelBindingsImpl channelBindings = new AsyncApi25ChannelBindingsImpl();
        AsyncApi25BindingImpl asyncApi25Binding = new AsyncApi25BindingImpl();
        BalAsyncApi25SchemaImpl bindingQueryObject = new BalAsyncApi25SchemaImpl();
        BalAsyncApi25SchemaImpl bindingHeaderObject = new BalAsyncApi25SchemaImpl();
        bindingQueryObject.setType(Constants.AsyncAPIType.OBJECT.toString());
        bindingHeaderObject.setType(Constants.AsyncAPIType.OBJECT.toString());
        AsyncApiQueryParameterMapper queryParameterMapper = new AsyncApiQueryParameterMapper(this.apidocs, this.components, this.semanticModel);
        for (ParameterNode parameterNode : parameterList) {
            if (parameterNode.kind() == SyntaxKind.REQUIRED_PARAM) {
                RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
                if (requiredParameterNode.typeName().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE && requiredParameterNode.annotations().isEmpty()) {
                    queryParameterMapper.createQueryParameter(requiredParameterNode, bindingQueryObject);
                }
                if (!(requiredParameterNode.typeName() instanceof TypeDescriptorNode) || requiredParameterNode.annotations().isEmpty()) continue;
                this.handleHeaderParameters(requiredParameterNode, bindingHeaderObject);
                continue;
            }
            if (parameterNode.kind() != SyntaxKind.DEFAULTABLE_PARAM) continue;
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
            if (defaultableParameterNode.typeName() instanceof TypeDescriptorNode && !defaultableParameterNode.annotations().isEmpty()) {
                this.handleDefaultableHeaderParameters(defaultableParameterNode, bindingHeaderObject);
                continue;
            }
            queryParameterMapper.createQueryParameter(defaultableParameterNode, bindingQueryObject);
        }
        ObjectMapper objectMapper = ConverterCommonUtils.callObjectMapper();
        TextNode bindingVersion = new TextNode("0.1.0");
        asyncApi25Binding.addItem("bindingVersion", (JsonNode)bindingVersion);
        if (bindingQueryObject.getProperties() != null) {
            ObjectNode queryObj = (ObjectNode)objectMapper.valueToTree((Object)bindingQueryObject);
            asyncApi25Binding.addItem("query", (JsonNode)queryObj);
        }
        if (bindingHeaderObject.getProperties() != null) {
            ObjectNode headerObj = (ObjectNode)objectMapper.valueToTree((Object)bindingHeaderObject);
            asyncApi25Binding.addItem("headers", (JsonNode)headerObj);
        }
        channelBindings.setWs(asyncApi25Binding);
        return channelBindings;
    }

    private AsyncApi25ParametersImpl createPathParameters(NodeList<Node> pathParams) {
        AsyncApi25ParametersImpl parameters = new AsyncApi25ParametersImpl();
        for (Node param : pathParams) {
            if (!(param instanceof ResourcePathParameterNode)) continue;
            AsyncApi25ParameterImpl pathParameterAAS = new AsyncApi25ParameterImpl();
            ResourcePathParameterNode pathParam = (ResourcePathParameterNode)param;
            String parameterItemName = ConverterCommonUtils.unescapeIdentifier(((Token)pathParam.paramName().get()).text());
            if (parameterItemName.contains("-")) {
                throw new NoSuchElementException("ERROR: Path parameter contains an invalid character '-'");
            }
            if (pathParam.typeDescriptor().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                SimpleNameReferenceNode queryNode = (SimpleNameReferenceNode)pathParam.typeDescriptor();
                AsyncApiComponentMapper componentMapper = new AsyncApiComponentMapper(this.components);
                TypeSymbol typeSymbol = (TypeSymbol)this.semanticModel.symbol((Node)queryNode).orElseThrow();
                componentMapper.createComponentSchema(typeSymbol, null);
                BalAsyncApi25SchemaImpl schema = new BalAsyncApi25SchemaImpl();
                schema.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(queryNode.name().text().trim()));
                pathParameterAAS.setSchema(schema);
            } else {
                pathParameterAAS.setSchema(ConverterCommonUtils.getAsyncApiSchema(pathParam.typeDescriptor().toString().trim()));
            }
            if (!this.apidocs.isEmpty() && this.apidocs.containsKey(((Token)pathParam.paramName().get()).text().trim())) {
                pathParameterAAS.setDescription(this.apidocs.get(((Token)pathParam.paramName().get()).text().trim()));
            }
            parameters.addItem(parameterItemName, pathParameterAAS);
        }
        return parameters;
    }

    private void handleHeaderParameters(RequiredParameterNode requiredParameterNode, BalAsyncApi25SchemaImpl bindingHeaderObject) {
        NodeList annotations = requiredParameterNode.annotations();
        for (AnnotationNode annotation : annotations) {
            if (!annotation.annotReference().toString().trim().equals("http:Header")) continue;
            AsyncApiHeaderMapper asyncAPIHeaderMapper = new AsyncApiHeaderMapper(this.apidocs);
            asyncAPIHeaderMapper.setHeaderParameter(requiredParameterNode, bindingHeaderObject);
        }
    }

    private void handleDefaultableHeaderParameters(DefaultableParameterNode defaultableParameterNode, BalAsyncApi25SchemaImpl bindingHeaderObject) {
        NodeList annotations = defaultableParameterNode.annotations();
        for (AnnotationNode annotation : annotations) {
            if (!annotation.annotReference().toString().trim().equals("http:Header")) continue;
            AsyncApiHeaderMapper asyncAPIHeaderMapper = new AsyncApiHeaderMapper(this.apidocs);
            asyncAPIHeaderMapper.setHeaderParameter(defaultableParameterNode, bindingHeaderObject);
        }
    }
}

