/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.client.IntermediateClientGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class TestGenerator {
    private final IntermediateClientGenerator intermediateClientGenerator;
    private final List<String> remoteFunctionNameList;
    private final String configFileName;
    private final boolean isHttpOrOAuth;

    public TestGenerator(IntermediateClientGenerator intermediateClientGenerator) {
        this.intermediateClientGenerator = intermediateClientGenerator;
        this.remoteFunctionNameList = intermediateClientGenerator.getRemoteFunctionNameList();
        this.configFileName = "";
        this.isHttpOrOAuth = false;
    }

    public SyntaxTree generateSyntaxTree() throws IOException, BallerinaAsyncApiExceptionWs {
        ArrayList<FunctionDefinitionNode> functions = new ArrayList<FunctionDefinitionNode>();
        this.getFunctionDefinitionNodes(functions);
        ArrayList<ModuleVariableDeclarationNode> nodes = new ArrayList<ModuleVariableDeclarationNode>(this.getModuleVariableDeclarationNodes());
        NodeList<ImportDeclarationNode> imports = this.getImportNodes();
        nodes.addAll(functions);
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)AbstractNodeFactory.createNodeList(nodes), (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private NodeList<ImportDeclarationNode> getImportNodes() {
        ImportDeclarationNode importForTest = GeneratorUtils.getImportDeclarationNode("ballerina", "test");
        ImportDeclarationNode importForHttp = GeneratorUtils.getImportDeclarationNode("ballerina", "http");
        NodeList imports = this.isHttpOrOAuth ? AbstractNodeFactory.createNodeList((Node[])new ImportDeclarationNode[]{importForTest, importForHttp}) : AbstractNodeFactory.createNodeList((Node[])new ImportDeclarationNode[]{importForTest});
        return imports;
    }

    public String getConfigTomlFile() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!this.configFileName.isBlank()) {
            if (!this.isHttpOrOAuth) {
                StringBuilder configFileContent = new StringBuilder("[apiKeyConfig]\n");
                for (String apiKey : this.intermediateClientGenerator.getApiKeyNameList()) {
                    configFileContent.append(GeneratorUtils.getValidName(apiKey, false)).append(" = \"<Enter Value>\"\n");
                }
                return configFileContent.toString();
            }
            InputStream inputStream = classLoader.getResourceAsStream("config_toml_files/" + this.configFileName);
            if (inputStream != null) {
                return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        return "";
    }

    private List<ModuleVariableDeclarationNode> getModuleVariableDeclarationNodes() {
        ArrayList<ModuleVariableDeclarationNode> moduleVariableDeclarationNodes = new ArrayList<ModuleVariableDeclarationNode>();
        moduleVariableDeclarationNodes.add(this.getClientInitForNoAuth());
        return moduleVariableDeclarationNodes;
    }

    private ModuleVariableDeclarationNode getClientInitForNoAuth() {
        String clientName = this.intermediateClientGenerator.getClientName();
        String serverURL = this.intermediateClientGenerator.getServerUrl();
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)clientName));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"baseClient"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        Token openParenArg = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenArg = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        Token newKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD);
        ArrayList<NamedArgumentNode> argumentsList = new ArrayList<NamedArgumentNode>();
        RequiredExpressionNode expressionNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + serverURL + "\"")));
        NamedArgumentNode positionalArgumentNode = NodeFactory.createNamedArgumentNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"serviceUrl")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)expressionNode);
        argumentsList.add(positionalArgumentNode);
        SeparatedNodeList arguments = AbstractNodeFactory.createSeparatedNodeList(argumentsList);
        ParenthesizedArgList parenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)openParenArg, (SeparatedNodeList)arguments, (Token)closeParenArg);
        BuiltinSimpleNameReferenceNode clientClassType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)clientName));
        ExplicitNewExpressionNode explicitNewExpressionNode = NodeFactory.createExplicitNewExpressionNode((Token)newKeyWord, (TypeDescriptorNode)clientClassType, (ParenthesizedArgList)parenthesizedArgList);
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)explicitNewExpressionNode);
        NodeList nodeList = AbstractNodeFactory.createEmptyNodeList();
        return NodeFactory.createModuleVariableDeclarationNode((MetadataNode)metadataNode, null, (NodeList)nodeList, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private void getFunctionDefinitionNodes(List<FunctionDefinitionNode> functions) {
        if (!this.remoteFunctionNameList.isEmpty()) {
            for (String functionName : this.remoteFunctionNameList) {
                MetadataNode metadataNode = this.getAnnotation();
                Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
                IdentifierToken testFunctionName = AbstractNodeFactory.createIdentifierToken((String)(" test" + this.modifyFunctionName(functionName.trim())));
                FunctionSignatureNode functionSignatureNode = this.getFunctionSignature();
                FunctionBodyNode functionBodyNode = this.getFunctionBody();
                NodeList relativeResourcePath = AbstractNodeFactory.createEmptyNodeList();
                IdentifierToken isolatedQualifierNode = AbstractNodeFactory.createIdentifierToken((String)"isolated");
                NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{isolatedQualifierNode});
                FunctionDefinitionNode functionDefinitionNode = NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, (MetadataNode)metadataNode, (NodeList)qualifierList, (Token)functionKeyWord, (IdentifierToken)testFunctionName, (NodeList)relativeResourcePath, (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
                functions.add(functionDefinitionNode);
            }
        }
    }

    private FunctionSignatureNode getFunctionSignature() {
        ArrayList parameterList = new ArrayList();
        SeparatedNodeList parameters = AbstractNodeFactory.createSeparatedNodeList(parameterList);
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameters, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), null);
    }

    private FunctionBodyNode getFunctionBody() {
        ArrayList statementsList = new ArrayList();
        NodeList statementsNodeList = AbstractNodeFactory.createNodeList(statementsList);
        return NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementsNodeList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private MetadataNode getAnnotation() {
        SimpleNameReferenceNode annotateReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"test:Config"));
        ArrayList fileds = new ArrayList();
        SeparatedNodeList fieldNodesList = AbstractNodeFactory.createSeparatedNodeList(fileds);
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)fieldNodesList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        AnnotationNode annotationNode = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotateReference, (MappingConstructorExpressionNode)annotValue);
        return NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{annotationNode}));
    }

    private String modifyFunctionName(String name) {
        return name.substring(0, 1).toUpperCase(Locale.getDefault()) + name.substring(1);
    }
}

