/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema;

import com.fasterxml.jackson.databind.node.BooleanNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.document.DocCommentsGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.AllOfRecordTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.AnyDataTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ArrayTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.JsonTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.MapTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.PrimitiveTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.RecordTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ReferencedTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.UnionTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.model.GeneratorMetaData;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TypeGeneratorUtils {
    private static final List<String> primitiveTypeList = new ArrayList<String>(Arrays.asList("integer", "number", "string", "boolean"));
    private static final PrintStream OUT_STREAM = System.err;

    public static TypeGenerator getTypeGenerator(AsyncApi25SchemaImpl schemaValue, String typeName, String parentName) throws BallerinaAsyncApiExceptionWs {
        if (schemaValue.getType() != null) {
            GeneratorUtils.convertAsyncAPITypeToBallerina(schemaValue.getType());
        }
        if (schemaValue.get$ref() != null) {
            return new ReferencedTypeGenerator(schemaValue, typeName);
        }
        if (schemaValue.getType() != null && schemaValue.getType().equals("array")) {
            return new ArrayTypeGenerator(schemaValue, typeName, parentName);
        }
        if (schemaValue.getType() != null && primitiveTypeList.contains(schemaValue.getType())) {
            return new PrimitiveTypeGenerator(schemaValue, typeName);
        }
        if (schemaValue.getOneOf() != null || schemaValue.getAllOf() != null || schemaValue.getAnyOf() != null) {
            if (schemaValue.getAllOf() != null) {
                return new AllOfRecordTypeGenerator(schemaValue, typeName);
            }
            return new UnionTypeGenerator(schemaValue, typeName);
        }
        if (schemaValue.getType() != null && schemaValue.getType().equals("object") || schemaValue.getProperties() != null) {
            return new RecordTypeGenerator(schemaValue, typeName);
        }
        if (schemaValue.getType() != null && schemaValue.getType().equals("object") && schemaValue.getAdditionalProperties() != null && (schemaValue.getAdditionalProperties() instanceof AsyncApi25SchemaImpl || schemaValue.getAdditionalProperties() instanceof BooleanUnionValueImpl && schemaValue.getAdditionalProperties().asBoolean().equals(true))) {
            return new MapTypeGenerator(schemaValue, typeName);
        }
        if (schemaValue.getType() == null && schemaValue.getProperties() == null && schemaValue.getAdditionalProperties() != null) {
            return new JsonTypeGenerator(schemaValue, typeName);
        }
        return new AnyDataTypeGenerator(schemaValue, typeName);
    }

    public static TypeDescriptorNode getNullableType(AsyncApi25SchemaImpl schema, TypeDescriptorNode originalTypeDesc) {
        TypeDescriptorNode nillableType = originalTypeDesc;
        if (schema.getExtensions() != null && schema.getExtensions().get("x-nullable") != null && schema.getExtensions().get("x-nullable").equals((Object)BooleanNode.TRUE)) {
            nillableType = NodeFactory.createOptionalTypeDescriptorNode((Node)originalTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        return nillableType;
    }

    public static ImmutablePair<List<Node>, Set<String>> updateRecordFieldListWithImports(List<String> required, List<Node> recordFieldList, Map.Entry<String, Schema> field, AsyncApi25SchemaImpl fieldSchema, NodeList<Node> schemaDocNodes, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName) {
        return TypeGeneratorUtils.updateRecordFieldListWithImports(required, recordFieldList, field, fieldSchema, schemaDocNodes, fieldName, fieldTypeName, System.err);
    }

    public static ImmutablePair<List<Node>, Set<String>> updateRecordFieldListWithImports(List<String> required, List<Node> recordFieldList, Map.Entry<String, Schema> field, AsyncApi25SchemaImpl fieldSchema, NodeList<Node> schemaDocNodes, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName, PrintStream outStream) {
        MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode(schemaDocNodes);
        HashSet<String> imports = new HashSet<String>();
        AnnotationNode constraintNode = null;
        boolean isConstraintSupport = false;
        if (fieldSchema != null) {
            constraintNode = TypeGeneratorUtils.generateConstraintNode(fieldName.text(), fieldSchema);
            boolean bl = isConstraintSupport = constraintNode != null && fieldSchema.getExtensions() != null && fieldSchema.getExtensions().get("x-nullable") != null || (fieldSchema.getOneOf() != null || fieldSchema.getAllOf() != null || fieldSchema.getAnyOf() != null) && (fieldSchema.getOneOf() != null || fieldSchema.getAnyOf() != null);
        }
        if (isConstraintSupport) {
            outStream.printf("WARNING: constraints in the AsyncAPI contract will be ignored for the field `%s`, as constraints are not supported on Ballerina union types%n", fieldName.toString().trim());
            constraintNode = null;
        }
        MetadataNode metadataNode = constraintNode == null ? NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList()) : NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{constraintNode}));
        if (required != null) {
            TypeGeneratorUtils.setRequiredFields(required, recordFieldList, field, fieldSchema, fieldName, fieldTypeName, metadataNode);
        } else {
            RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            recordFieldList.add((Node)recordFieldNode);
        }
        if (constraintNode != null) {
            ImportDeclarationNode constraintImport = GeneratorUtils.getImportDeclarationNode("ballerina", "constraint");
            constraintImport.toSourceCode();
            imports.add(constraintImport.toSourceCode());
        }
        return new ImmutablePair(recordFieldList, imports);
    }

    private static void setRequiredFields(List<String> required, List<Node> recordFieldList, Map.Entry<String, Schema> field, AsyncApi25SchemaImpl fieldSchema, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName, MetadataNode metadataNode) {
        if (!required.contains(field.getKey().trim())) {
            if (fieldSchema.getDefault() != null) {
                RecordFieldWithDefaultValueNode defaultNode = TypeGeneratorUtils.getRecordFieldWithDefaultValueNode(fieldSchema, fieldName, fieldTypeName, metadataNode);
                recordFieldList.add((Node)defaultNode);
            } else {
                RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                recordFieldList.add((Node)recordFieldNode);
            }
        } else if (fieldSchema.getDefault() != null) {
            RecordFieldWithDefaultValueNode defaultNode = TypeGeneratorUtils.getRecordFieldWithDefaultValueNode(fieldSchema, fieldName, fieldTypeName, metadataNode);
            recordFieldList.add((Node)defaultNode);
        } else {
            RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            recordFieldList.add((Node)recordFieldNode);
        }
    }

    private static RecordFieldWithDefaultValueNode getRecordFieldWithDefaultValueNode(AsyncApi25SchemaImpl fieldSchema, IdentifierToken fieldName, TypeDescriptorNode fieldTypeName, MetadataNode metadataNode) {
        String defaultValue = fieldSchema.getDefault().toString().trim();
        IdentifierToken defaultValueToken = fieldSchema.getType() != null && fieldSchema.getType().equals("string") || fieldSchema.getType() == null ? (defaultValue.equals("\"") ? AbstractNodeFactory.createIdentifierToken((String)("\"\\" + fieldSchema.getDefault().asText() + "\"")) : AbstractNodeFactory.createIdentifierToken((String)fieldSchema.getDefault().toString())) : (!(defaultValue.matches("^[0-9]*$") || defaultValue.matches("^(\\d*\\.)?\\d+$") || defaultValue.startsWith("[") && defaultValue.endsWith("]") || fieldSchema.getType() != null && fieldSchema.getType().equals("boolean")) ? AbstractNodeFactory.createIdentifierToken((String)fieldSchema.getDefault().asText()) : AbstractNodeFactory.createIdentifierToken((String)fieldSchema.getDefault().toString().trim().replaceAll("\\\\", "")));
        RequiredExpressionNode expressionNode = NodeFactory.createRequiredExpressionNode((Token)defaultValueToken);
        return NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)expressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public static AnnotationNode generateConstraintNode(String typeName, AsyncApi25SchemaImpl fieldSchema) {
        if (fieldSchema.getType() != null && TypeGeneratorUtils.isConstraintAllowed(typeName, fieldSchema)) {
            if (fieldSchema.getType().equals("string")) {
                AsyncApi25SchemaImpl stringSchema = fieldSchema;
                return TypeGeneratorUtils.generateStringConstraint(stringSchema);
            }
            if (fieldSchema.getType().equals("integer") || fieldSchema.getType().equals("number")) {
                return TypeGeneratorUtils.generateNumberConstraint(fieldSchema);
            }
            if (fieldSchema.getType().equals("array")) {
                AsyncApi25SchemaImpl arraySchema = fieldSchema;
                return TypeGeneratorUtils.generateArrayConstraint(arraySchema);
            }
            return null;
        }
        return null;
    }

    public static boolean isConstraintAllowed(String typeName, AsyncApi25SchemaImpl schema) {
        boolean isConstraintNotAllowed;
        boolean bl = isConstraintNotAllowed = schema.getExtensions() != null && schema.getExtensions().get("x-nullable") != null || schema.getOneOf() != null && schema.getAllOf() != null && schema.getAnyOf() != null && (schema.getOneOf() != null || schema.getAnyOf() != null);
        if (isConstraintNotAllowed) {
            OUT_STREAM.printf("WARNING: constraints in the AsyncAPI contract will be ignored for the type `%s`, as constraints are not supported on Ballerina union types%n", typeName.trim());
            return false;
        }
        return true;
    }

    private static AnnotationNode generateNumberConstraint(AsyncApi25SchemaImpl fieldSchema) {
        List<String> fields = TypeGeneratorUtils.getNumberAnnotFields(fieldSchema);
        if (fields.isEmpty()) {
            return null;
        }
        String annotBody = "{" + String.join((CharSequence)",", fields) + "}";
        AnnotationNode annotationNode = fieldSchema.getType().equals("number") ? (fieldSchema.getFormat() != null && fieldSchema.getFormat().equals("float") ? TypeGeneratorUtils.createAnnotationNode("constraint:Float", annotBody) : TypeGeneratorUtils.createAnnotationNode("constraint:Number", annotBody)) : TypeGeneratorUtils.createAnnotationNode("constraint:Int", annotBody);
        return annotationNode;
    }

    private static AnnotationNode generateStringConstraint(AsyncApi25SchemaImpl stringSchema) {
        List<String> fields = TypeGeneratorUtils.getStringAnnotFields(stringSchema);
        if (fields.isEmpty()) {
            return null;
        }
        String annotBody = "{" + String.join((CharSequence)",", fields) + "}";
        return TypeGeneratorUtils.createAnnotationNode("constraint:String", annotBody);
    }

    private static AnnotationNode generateArrayConstraint(AsyncApi25SchemaImpl arraySchema) {
        List<String> fields = TypeGeneratorUtils.getArrayAnnotFields(arraySchema);
        if (fields.isEmpty()) {
            return null;
        }
        String annotBody = "{" + String.join((CharSequence)",", fields) + "}";
        return TypeGeneratorUtils.createAnnotationNode("constraint:Array", annotBody);
    }

    private static List<String> getNumberAnnotFields(AsyncApi25SchemaImpl numberSchema) {
        String fieldRef;
        String value;
        ArrayList<String> fields = new ArrayList<String>();
        boolean isInt = numberSchema.getType().equals("integer");
        if (numberSchema.getMinimum() != null && numberSchema.getExclusiveMinimum() == null) {
            value = numberSchema.getMinimum().toString();
            fieldRef = "minValue:" + String.valueOf(isInt ? Integer.valueOf(numberSchema.getMinimum().intValue()) : value);
            fields.add(fieldRef);
        }
        if (numberSchema.getMaximum() != null && numberSchema.getExclusiveMaximum() == null) {
            value = numberSchema.getMaximum().toString();
            fieldRef = "maxValue:" + String.valueOf(isInt ? Integer.valueOf(numberSchema.getMaximum().intValue()) : value);
            fields.add(fieldRef);
        }
        if (numberSchema.getExclusiveMinimum() != null && numberSchema.getMinimum() != null) {
            value = numberSchema.getMinimum().toString();
            fieldRef = "minValueExclusive:" + String.valueOf(isInt ? Integer.valueOf(numberSchema.getMinimum().intValue()) : value);
            fields.add(fieldRef);
        }
        if (numberSchema.getExclusiveMaximum() != null && numberSchema.getMaximum() != null) {
            value = numberSchema.getMaximum().toString();
            fieldRef = "maxValueExclusive:" + String.valueOf(isInt ? Integer.valueOf(numberSchema.getMaximum().intValue()) : value);
            fields.add(fieldRef);
        }
        return fields;
    }

    private static List<String> getStringAnnotFields(AsyncApi25SchemaImpl stringSchema) {
        String fieldRef;
        String value;
        ArrayList<String> fields = new ArrayList<String>();
        if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() != 0) {
            value = stringSchema.getMaxLength().toString();
            fieldRef = "maxLength:" + value;
            fields.add(fieldRef);
        }
        if (stringSchema.getMinLength() != null && stringSchema.getMinLength() != 0) {
            value = stringSchema.getMinLength().toString();
            fieldRef = "minLength:" + value;
            fields.add(fieldRef);
        }
        return fields;
    }

    private static List<String> getArrayAnnotFields(AsyncApi25SchemaImpl arraySchema) {
        String fieldRef;
        String value;
        ArrayList<String> fields = new ArrayList<String>();
        if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() != 0) {
            value = arraySchema.getMaxItems().toString();
            fieldRef = "maxLength:" + value;
            fields.add(fieldRef);
        }
        if (arraySchema.getMinItems() != null && arraySchema.getMinItems() != 0) {
            value = arraySchema.getMinItems().toString();
            fieldRef = "minLength:" + value;
            fields.add(fieldRef);
        }
        return fields;
    }

    private static AnnotationNode createAnnotationNode(String annotationReference, String annotFields) {
        MappingConstructorExpressionNode annotationBody = null;
        SimpleNameReferenceNode annotReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)annotationReference));
        ExpressionNode expressionNode = NodeParser.parseExpression((String)annotFields);
        if (expressionNode.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
            annotationBody = (MappingConstructorExpressionNode)expressionNode;
        }
        return NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotReference, (MappingConstructorExpressionNode)annotationBody);
    }

    public static List<Node> getFieldApiDocs(AsyncApi25SchemaImpl field) {
        ArrayList<Node> schemaDoc = new ArrayList<Node>();
        if (field.getDescription() != null) {
            schemaDoc.addAll(DocCommentsGenerator.createAPIDescriptionDoc(field.getDescription(), false));
        } else if (field.get$ref() != null) {
            AsyncApi25SchemaImpl schema;
            String[] split = field.get$ref().trim().split("/");
            String componentName = GeneratorUtils.getValidName(split[split.length - 1], true);
            AsyncApi25DocumentImpl asyncAPI = GeneratorMetaData.getInstance().getAsyncAPI();
            if (asyncAPI.getComponents().getSchemas().get(componentName) != null && (schema = (AsyncApi25SchemaImpl)asyncAPI.getComponents().getSchemas().get(componentName)).getDescription() != null) {
                schemaDoc.addAll(DocCommentsGenerator.createAPIDescriptionDoc(schema.getDescription(), false));
            }
        }
        return schemaDoc;
    }

    public static void getRecordDocs(List<Node> documentation, AsyncApi25SchemaImpl schemaValue) throws BallerinaAsyncApiExceptionWs {
        if (schemaValue.getDescription() != null) {
            documentation.addAll(DocCommentsGenerator.createAPIDescriptionDoc(schemaValue.getDescription(), false));
        } else if (schemaValue.get$ref() != null) {
            String typeName = GeneratorUtils.getValidName(GeneratorUtils.extractReferenceType(schemaValue.get$ref()), true);
            AsyncApi25SchemaImpl refSchema = (AsyncApi25SchemaImpl)GeneratorMetaData.getInstance().getAsyncAPI().getComponents().getSchemas().get(typeName);
            if (refSchema.getDescription() != null) {
                documentation.addAll(DocCommentsGenerator.createAPIDescriptionDoc(refSchema.getDescription(), false));
            }
        }
    }
}

