/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators;

import com.fasterxml.jackson.databind.node.BooleanNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.apicurio.datamodels.models.union.BooleanSchemaUnion;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.schema.TypeGeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ArrayTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.PrimitiveTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ReferencedTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.UnionTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.model.RecordMetadata;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RecordTypeGenerator
extends TypeGenerator {
    public static final PrintStream OUT_STREAM = System.err;

    public RecordTypeGenerator(AsyncApi25SchemaImpl schema, String typeName) {
        super(schema, typeName);
    }

    public static RecordRestDescriptorNode getRestDescriptorNodeForReference(AsyncApi25SchemaImpl additionalPropSchema) throws BallerinaAsyncApiExceptionWs {
        ReferencedTypeGenerator referencedTypeGenerator = new ReferencedTypeGenerator(additionalPropSchema, null);
        TypeDescriptorNode refNode = referencedTypeGenerator.generateTypeDescriptorNode();
        return NodeFactory.createRecordRestDescriptorNode((Node)refNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public static RecordRestDescriptorNode getRecordRestDescriptorNode(AsyncApi25SchemaImpl additionalPropSchema) throws BallerinaAsyncApiExceptionWs {
        RecordRestDescriptorNode recordRestDescNode = null;
        if (additionalPropSchema.getType() != null && additionalPropSchema.getType().equals("number") && additionalPropSchema.getFormat() != null) {
            String type = additionalPropSchema.getFormat();
            SimpleNameReferenceNode numberNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)type));
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)TypeGeneratorUtils.getNullableType(additionalPropSchema, (TypeDescriptorNode)numberNode), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else if (additionalPropSchema.getType() != null && additionalPropSchema.getType().equals("object")) {
            RecordTypeGenerator record = new RecordTypeGenerator(additionalPropSchema, null);
            TypeDescriptorNode recordNode = TypeGeneratorUtils.getNullableType(additionalPropSchema, record.generateTypeDescriptorNode());
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)recordNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else if (additionalPropSchema.getType() != null && additionalPropSchema.getType().equals("array")) {
            ArrayTypeGenerator arrayTypeGenerator = new ArrayTypeGenerator(additionalPropSchema, null, null);
            TypeDescriptorNode arrayNode = arrayTypeGenerator.generateTypeDescriptorNode();
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)arrayNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else if (additionalPropSchema.getType() != null && additionalPropSchema.getType().equals("integer") || additionalPropSchema.getType().equals("string") || additionalPropSchema.getType().equals("boolean")) {
            PrimitiveTypeGenerator primitiveTypeGenerator = new PrimitiveTypeGenerator(additionalPropSchema, null);
            TypeDescriptorNode primitiveNode = primitiveTypeGenerator.generateTypeDescriptorNode();
            recordRestDescNode = NodeFactory.createRecordRestDescriptorNode((Node)primitiveNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        } else {
            OUT_STREAM.printf("WARNING: the Ballerina rest record field does not support with the data type `%s`", additionalPropSchema.getType());
        }
        return recordRestDescNode;
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws BallerinaAsyncApiExceptionWs {
        LinkedList<Node> recordFields = new LinkedList<Node>();
        RecordMetadata metadataBuilder = this.getRecordMetadata();
        if (this.schema.getProperties() != null) {
            Map<String, Schema> properties = this.schema.getProperties();
            List<String> required = this.schema.getRequired();
            List<Node> generatedRecordFields = this.addRecordFields(required, properties.entrySet(), this.typeName);
            recordFields.addAll(generatedRecordFields);
            NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFields);
            RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN)), (NodeList)fieldNodes, (RecordRestDescriptorNode)metadataBuilder.getRestDescriptorNode(), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN)));
            if (this.schema.getExtensions() != null && this.schema.getExtensions().containsKey("readOnly") && this.schema.getExtensions().get("readOnly").equals((Object)BooleanNode.TRUE)) {
                return NodeFactory.createIntersectionTypeDescriptorNode((Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"readonly")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BITWISE_AND_TOKEN), (Node)recordTypeDescriptorNode);
            }
            return recordTypeDescriptorNode;
        }
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN)), (NodeList)AbstractNodeFactory.createNodeList(recordFields), (RecordRestDescriptorNode)metadataBuilder.getRestDescriptorNode(), (Token)(metadataBuilder.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN)));
        if (this.schema.getExtensions() != null && this.schema.getExtensions().containsKey("readOnly") && this.schema.getExtensions().get("readOnly").equals((Object)BooleanNode.TRUE)) {
            return NodeFactory.createIntersectionTypeDescriptorNode((Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"readonly")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BITWISE_AND_TOKEN), (Node)recordTypeDescriptorNode);
        }
        return recordTypeDescriptorNode;
    }

    public RecordMetadata getRecordMetadata() throws BallerinaAsyncApiExceptionWs {
        boolean isOpenRecord = true;
        RecordRestDescriptorNode recordRestDescNode = null;
        if (this.schema.getAdditionalProperties() != null) {
            BooleanSchemaUnion additionalProperties = this.schema.getAdditionalProperties();
            if (additionalProperties instanceof Schema) {
                AsyncApi25SchemaImpl additionalPropSchema = (AsyncApi25SchemaImpl)additionalProperties;
                if (GeneratorUtils.hasConstraints(additionalPropSchema)) {
                    isOpenRecord = false;
                    OUT_STREAM.println("WARNING: constraints in the AsyncAPI contract will be ignored for the additionalProperties field, as constraints are not supported on Ballerina rest record field.");
                }
                if (additionalPropSchema.get$ref() != null) {
                    isOpenRecord = false;
                    recordRestDescNode = RecordTypeGenerator.getRestDescriptorNodeForReference(additionalPropSchema);
                } else if (additionalPropSchema.getType() != null) {
                    isOpenRecord = false;
                    recordRestDescNode = RecordTypeGenerator.getRecordRestDescriptorNode(additionalPropSchema);
                } else if (additionalPropSchema.getOneOf() != null || additionalPropSchema.getAllOf() != null || additionalPropSchema.getAnyOf() != null) {
                    OUT_STREAM.println("WARNING: generating Ballerina rest record field will be ignored for the AsyncAPI contract additionalProperties type `allOf, oneOf, anyOf`, as it is not supported on Ballerina rest record field.");
                }
            } else if (additionalProperties.asBoolean().equals(false)) {
                isOpenRecord = false;
            }
        }
        return new RecordMetadata.Builder().withIsOpenRecord(isOpenRecord).withRestDescriptorNode(recordRestDescNode).build();
    }

    public List<Node> addRecordFields(List<String> required, Set<Map.Entry<String, Schema>> fields, String recordName) throws BallerinaAsyncApiExceptionWs {
        List<Object> recordFieldList = new ArrayList<Node>();
        for (Map.Entry<String, Schema> field : fields) {
            String fieldNameStr = GeneratorUtils.escapeIdentifier(field.getKey().trim());
            AsyncApi25SchemaImpl fieldSchema = (AsyncApi25SchemaImpl)field.getValue();
            List<Node> schemaDoc = TypeGeneratorUtils.getFieldApiDocs(fieldSchema);
            NodeList schemaDocNodes = AbstractNodeFactory.createNodeList(schemaDoc);
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)fieldNameStr);
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(fieldSchema, fieldNameStr, recordName);
            TypeDescriptorNode fieldTypeName = typeGenerator.generateTypeDescriptorNode();
            if (typeGenerator instanceof RecordTypeGenerator) {
                fieldTypeName = TypeGeneratorUtils.getNullableType(fieldSchema, fieldTypeName);
            }
            if (typeGenerator instanceof ArrayTypeGenerator && !typeGenerator.getTypeDefinitionNodeList().isEmpty()) {
                this.typeDefinitionNodeList.addAll(typeGenerator.getTypeDefinitionNodeList());
            } else if (typeGenerator instanceof UnionTypeGenerator && !typeGenerator.getTypeDefinitionNodeList().isEmpty()) {
                List<TypeDefinitionNode> newConstraintNode = typeGenerator.getTypeDefinitionNodeList();
                this.typeDefinitionNodeList.addAll(newConstraintNode);
            }
            this.imports.addAll(typeGenerator.getImports());
            ImmutablePair<List<Node>, Set<String>> fieldListWithImports = TypeGeneratorUtils.updateRecordFieldListWithImports(required, recordFieldList, field, fieldSchema, (NodeList<Node>)schemaDocNodes, fieldName, fieldTypeName);
            recordFieldList = (List)fieldListWithImports.getLeft();
            this.imports.addAll((Collection)fieldListWithImports.getRight());
        }
        return recordFieldList;
    }
}

