/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.KeywordMode;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;

public class TokenReader
extends AbstractTokenReader {
    private static final int BUFFER_SIZE = 20;
    private final AbstractLexer lexer;
    private final TokenBuffer tokensAhead = new TokenBuffer(20);
    private STToken currentToken = null;

    TokenReader(AbstractLexer lexer) {
        this.lexer = lexer;
    }

    @Override
    public STToken read() {
        if (this.tokensAhead.size > 0) {
            this.currentToken = this.tokensAhead.consume();
            return this.currentToken;
        }
        this.currentToken = this.lexer.nextToken();
        return this.currentToken;
    }

    @Override
    public STToken peek() {
        if (this.tokensAhead.size > 0) {
            return this.tokensAhead.peek();
        }
        STToken token = this.lexer.nextToken();
        this.tokensAhead.add(token);
        return token;
    }

    @Override
    public STToken peek(int k) {
        TokenBuffer tokensAhead = this.tokensAhead;
        while (tokensAhead.size < k) {
            STToken nextToken = this.lexer.nextToken();
            if (tokensAhead.size == tokensAhead.capacity) {
                STNode emptyTrivia = STNodeFactory.createEmptyNodeList();
                return STNodeFactory.createToken(SyntaxKind.EOF_TOKEN, emptyTrivia, emptyTrivia);
            }
            tokensAhead.add(nextToken);
        }
        return tokensAhead.peek(k);
    }

    @Override
    public STToken head() {
        return this.currentToken;
    }

    @Override
    public void startMode(ParserMode mode) {
        this.lexer.startMode(mode);
    }

    @Override
    public void switchMode(ParserMode mode) {
        this.lexer.switchMode(mode);
    }

    @Override
    public void endMode() {
        this.lexer.endMode();
    }

    @Override
    public void startKeywordMode(KeywordMode keywordMode) {
        this.lexer.startKeywordMode(keywordMode);
    }

    @Override
    public void endKeywordMode() {
        this.lexer.endKeywordMode();
    }

    @Override
    public ParserMode getCurrentMode() {
        return this.lexer.modeStack.peek();
    }

    @Override
    public int getCurrentTokenIndex() {
        return this.tokensAhead.getCurrentTokenIndex();
    }

    private static class TokenBuffer {
        private final int capacity;
        private final STToken[] tokens;
        private int endIndex = -1;
        private int startIndex = -1;
        private int size = 0;

        TokenBuffer(int size) {
            this.capacity = size;
            this.tokens = new STToken[size];
        }

        public void add(STToken token) {
            if (this.size == this.capacity) {
                throw new IndexOutOfBoundsException("buffer overflow");
            }
            this.endIndex = this.endIndex == this.capacity - 1 ? 0 : ++this.endIndex;
            if (this.size == 0) {
                this.startIndex = this.endIndex;
            }
            this.tokens[this.endIndex] = token;
            ++this.size;
        }

        public STToken consume() {
            STToken token = this.tokens[this.startIndex];
            --this.size;
            this.startIndex = this.startIndex == this.capacity - 1 ? 0 : ++this.startIndex;
            return token;
        }

        public STToken peek() {
            return this.tokens[this.startIndex];
        }

        public STToken peek(int k) {
            if (k > this.size) {
                throw new IndexOutOfBoundsException("size: " + this.size + ", index: " + k);
            }
            int index = this.startIndex + k - 1;
            if (index >= this.capacity) {
                index -= this.capacity;
            }
            return this.tokens[index];
        }

        public int getCurrentTokenIndex() {
            return this.startIndex;
        }
    }
}

