/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STIntermediateClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.JoinClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STJoinClauseNode
extends STIntermediateClauseNode {
    public final STNode outerKeyword;
    public final STNode joinKeyword;
    public final STNode typedBindingPattern;
    public final STNode inKeyword;
    public final STNode expression;
    public final STNode joinOnCondition;

    STJoinClauseNode(STNode outerKeyword, STNode joinKeyword, STNode typedBindingPattern, STNode inKeyword, STNode expression, STNode joinOnCondition) {
        this(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, joinOnCondition, Collections.emptyList());
    }

    STJoinClauseNode(STNode outerKeyword, STNode joinKeyword, STNode typedBindingPattern, STNode inKeyword, STNode expression, STNode joinOnCondition, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.JOIN_CLAUSE, diagnostics);
        this.outerKeyword = outerKeyword;
        this.joinKeyword = joinKeyword;
        this.typedBindingPattern = typedBindingPattern;
        this.inKeyword = inKeyword;
        this.expression = expression;
        this.joinOnCondition = joinOnCondition;
        this.addChildren(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, joinOnCondition);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STJoinClauseNode(this.outerKeyword, this.joinKeyword, this.typedBindingPattern, this.inKeyword, this.expression, this.joinOnCondition, diagnostics);
    }

    public STJoinClauseNode modify(STNode outerKeyword, STNode joinKeyword, STNode typedBindingPattern, STNode inKeyword, STNode expression, STNode joinOnCondition) {
        if (this.checkForReferenceEquality(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, joinOnCondition)) {
            return this;
        }
        return new STJoinClauseNode(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, joinOnCondition, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new JoinClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

