/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MappingMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMappingMatchPatternNode
extends STNode {
    public final STNode openBraceToken;
    public final STNode fieldMatchPatterns;
    public final STNode closeBraceToken;

    STMappingMatchPatternNode(STNode openBraceToken, STNode fieldMatchPatterns, STNode closeBraceToken) {
        this(openBraceToken, fieldMatchPatterns, closeBraceToken, Collections.emptyList());
    }

    STMappingMatchPatternNode(STNode openBraceToken, STNode fieldMatchPatterns, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MAPPING_MATCH_PATTERN, diagnostics);
        this.openBraceToken = openBraceToken;
        this.fieldMatchPatterns = fieldMatchPatterns;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(openBraceToken, fieldMatchPatterns, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMappingMatchPatternNode(this.openBraceToken, this.fieldMatchPatterns, this.closeBraceToken, diagnostics);
    }

    public STMappingMatchPatternNode modify(STNode openBraceToken, STNode fieldMatchPatterns, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, fieldMatchPatterns, closeBraceToken)) {
            return this;
        }
        return new STMappingMatchPatternNode(openBraceToken, fieldMatchPatterns, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MappingMatchPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

