/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReUnicodePropertyEscapeNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReUnicodePropertyEscapeNode
extends STNode {
    public final STNode slashToken;
    public final STNode property;
    public final STNode openBraceToken;
    public final STNode reUnicodeProperty;
    public final STNode closeBraceToken;

    STReUnicodePropertyEscapeNode(STNode slashToken, STNode property, STNode openBraceToken, STNode reUnicodeProperty, STNode closeBraceToken) {
        this(slashToken, property, openBraceToken, reUnicodeProperty, closeBraceToken, Collections.emptyList());
    }

    STReUnicodePropertyEscapeNode(STNode slashToken, STNode property, STNode openBraceToken, STNode reUnicodeProperty, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_UNICODE_PROPERTY_ESCAPE, diagnostics);
        this.slashToken = slashToken;
        this.property = property;
        this.openBraceToken = openBraceToken;
        this.reUnicodeProperty = reUnicodeProperty;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(slashToken, property, openBraceToken, reUnicodeProperty, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReUnicodePropertyEscapeNode(this.slashToken, this.property, this.openBraceToken, this.reUnicodeProperty, this.closeBraceToken, diagnostics);
    }

    public STReUnicodePropertyEscapeNode modify(STNode slashToken, STNode property, STNode openBraceToken, STNode reUnicodeProperty, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(slashToken, property, openBraceToken, reUnicodeProperty, closeBraceToken)) {
            return this;
        }
        return new STReUnicodePropertyEscapeNode(slashToken, property, openBraceToken, reUnicodeProperty, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReUnicodePropertyEscapeNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

