/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRecordFieldNode
extends STNode {
    public final STNode metadata;
    public final STNode readonlyKeyword;
    public final STNode typeName;
    public final STNode fieldName;
    public final STNode questionMarkToken;
    public final STNode semicolonToken;

    STRecordFieldNode(STNode metadata, STNode readonlyKeyword, STNode typeName, STNode fieldName, STNode questionMarkToken, STNode semicolonToken) {
        this(metadata, readonlyKeyword, typeName, fieldName, questionMarkToken, semicolonToken, Collections.emptyList());
    }

    STRecordFieldNode(STNode metadata, STNode readonlyKeyword, STNode typeName, STNode fieldName, STNode questionMarkToken, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RECORD_FIELD, diagnostics);
        this.metadata = metadata;
        this.readonlyKeyword = readonlyKeyword;
        this.typeName = typeName;
        this.fieldName = fieldName;
        this.questionMarkToken = questionMarkToken;
        this.semicolonToken = semicolonToken;
        this.addChildren(metadata, readonlyKeyword, typeName, fieldName, questionMarkToken, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRecordFieldNode(this.metadata, this.readonlyKeyword, this.typeName, this.fieldName, this.questionMarkToken, this.semicolonToken, diagnostics);
    }

    public STRecordFieldNode modify(STNode metadata, STNode readonlyKeyword, STNode typeName, STNode fieldName, STNode questionMarkToken, STNode semicolonToken) {
        if (this.checkForReferenceEquality(metadata, readonlyKeyword, typeName, fieldName, questionMarkToken, semicolonToken)) {
            return this;
        }
        return new STRecordFieldNode(metadata, readonlyKeyword, typeName, fieldName, questionMarkToken, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RecordFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

