/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLStepIndexedExtendNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLStepIndexedExtendNode
extends STNode {
    public final STNode openBracket;
    public final STNode expression;
    public final STNode closeBracket;

    STXMLStepIndexedExtendNode(STNode openBracket, STNode expression, STNode closeBracket) {
        this(openBracket, expression, closeBracket, Collections.emptyList());
    }

    STXMLStepIndexedExtendNode(STNode openBracket, STNode expression, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_STEP_INDEXED_EXTEND, diagnostics);
        this.openBracket = openBracket;
        this.expression = expression;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, expression, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLStepIndexedExtendNode(this.openBracket, this.expression, this.closeBracket, diagnostics);
    }

    public STXMLStepIndexedExtendNode modify(STNode openBracket, STNode expression, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, expression, closeBracket)) {
            return this;
        }
        return new STXMLStepIndexedExtendNode(openBracket, expression, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLStepIndexedExtendNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

