/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class AnnotAccessExpressionNode
extends ExpressionNode {
    public AnnotAccessExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token annotChainingToken() {
        return (Token)this.childInBucket(1);
    }

    public NameReferenceNode annotTagReference() {
        return (NameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "annotChainingToken", "annotTagReference"};
    }

    public AnnotAccessExpressionNode modify(ExpressionNode expression, Token annotChainingToken, NameReferenceNode annotTagReference) {
        if (this.checkForReferenceEquality(expression, annotChainingToken, annotTagReference)) {
            return this;
        }
        return NodeFactory.createAnnotAccessExpressionNode(expression, annotChainingToken, annotTagReference);
    }

    public AnnotAccessExpressionNodeModifier modify() {
        return new AnnotAccessExpressionNodeModifier(this);
    }

    public static class AnnotAccessExpressionNodeModifier {
        private final AnnotAccessExpressionNode oldNode;
        private ExpressionNode expression;
        private Token annotChainingToken;
        private NameReferenceNode annotTagReference;

        public AnnotAccessExpressionNodeModifier(AnnotAccessExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.annotChainingToken = oldNode.annotChainingToken();
            this.annotTagReference = oldNode.annotTagReference();
        }

        public AnnotAccessExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public AnnotAccessExpressionNodeModifier withAnnotChainingToken(Token annotChainingToken) {
            Objects.requireNonNull(annotChainingToken, "annotChainingToken must not be null");
            this.annotChainingToken = annotChainingToken;
            return this;
        }

        public AnnotAccessExpressionNodeModifier withAnnotTagReference(NameReferenceNode annotTagReference) {
            Objects.requireNonNull(annotTagReference, "annotTagReference must not be null");
            this.annotTagReference = annotTagReference;
            return this;
        }

        public AnnotAccessExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.annotChainingToken, this.annotTagReference);
        }
    }
}

