/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class AnnotationNode
extends NonTerminalNode {
    public AnnotationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token atToken() {
        return (Token)this.childInBucket(0);
    }

    public Node annotReference() {
        return this.childInBucket(1);
    }

    public Optional<MappingConstructorExpressionNode> annotValue() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"atToken", "annotReference", "annotValue"};
    }

    public AnnotationNode modify(Token atToken, Node annotReference, MappingConstructorExpressionNode annotValue) {
        if (this.checkForReferenceEquality(atToken, annotReference, annotValue)) {
            return this;
        }
        return NodeFactory.createAnnotationNode(atToken, annotReference, annotValue);
    }

    public AnnotationNodeModifier modify() {
        return new AnnotationNodeModifier(this);
    }

    public static class AnnotationNodeModifier {
        private final AnnotationNode oldNode;
        private Token atToken;
        private Node annotReference;
        private MappingConstructorExpressionNode annotValue;

        public AnnotationNodeModifier(AnnotationNode oldNode) {
            this.oldNode = oldNode;
            this.atToken = oldNode.atToken();
            this.annotReference = oldNode.annotReference();
            this.annotValue = oldNode.annotValue().orElse(null);
        }

        public AnnotationNodeModifier withAtToken(Token atToken) {
            Objects.requireNonNull(atToken, "atToken must not be null");
            this.atToken = atToken;
            return this;
        }

        public AnnotationNodeModifier withAnnotReference(Node annotReference) {
            Objects.requireNonNull(annotReference, "annotReference must not be null");
            this.annotReference = annotReference;
            return this;
        }

        public AnnotationNodeModifier withAnnotValue(MappingConstructorExpressionNode annotValue) {
            this.annotValue = annotValue;
            return this;
        }

        public AnnotationNode apply() {
            return this.oldNode.modify(this.atToken, this.annotReference, this.annotValue);
        }
    }
}

