/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MappingConstructorExpressionNode
extends ExpressionNode {
    public MappingConstructorExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<MappingFieldNode> fields() {
        return new SeparatedNodeList<MappingFieldNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBrace", "fields", "closeBrace"};
    }

    public MappingConstructorExpressionNode modify(Token openBrace, SeparatedNodeList<MappingFieldNode> fields, Token closeBrace) {
        if (this.checkForReferenceEquality(openBrace, fields.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
    }

    public MappingConstructorExpressionNodeModifier modify() {
        return new MappingConstructorExpressionNodeModifier(this);
    }

    public static class MappingConstructorExpressionNodeModifier {
        private final MappingConstructorExpressionNode oldNode;
        private Token openBrace;
        private SeparatedNodeList<MappingFieldNode> fields;
        private Token closeBrace;

        public MappingConstructorExpressionNodeModifier(MappingConstructorExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.openBrace = oldNode.openBrace();
            this.fields = oldNode.fields();
            this.closeBrace = oldNode.closeBrace();
        }

        public MappingConstructorExpressionNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public MappingConstructorExpressionNodeModifier withFields(SeparatedNodeList<MappingFieldNode> fields) {
            Objects.requireNonNull(fields, "fields must not be null");
            this.fields = fields;
            return this;
        }

        public MappingConstructorExpressionNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public MappingConstructorExpressionNode apply() {
            return this.oldNode.modify(this.openBrace, this.fields, this.closeBrace);
        }
    }
}

