/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.MatchGuardNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class MatchClauseNode
extends NonTerminalNode {
    public MatchClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SeparatedNodeList<Node> matchPatterns() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(0));
    }

    public Optional<MatchGuardNode> matchGuard() {
        return this.optionalChildInBucket(1);
    }

    public Token rightDoubleArrow() {
        return (Token)this.childInBucket(2);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"matchPatterns", "matchGuard", "rightDoubleArrow", "blockStatement"};
    }

    public MatchClauseNode modify(SeparatedNodeList<Node> matchPatterns, MatchGuardNode matchGuard, Token rightDoubleArrow, BlockStatementNode blockStatement) {
        if (this.checkForReferenceEquality(matchPatterns.underlyingListNode(), matchGuard, rightDoubleArrow, blockStatement)) {
            return this;
        }
        return NodeFactory.createMatchClauseNode(matchPatterns, matchGuard, rightDoubleArrow, blockStatement);
    }

    public MatchClauseNodeModifier modify() {
        return new MatchClauseNodeModifier(this);
    }

    public static class MatchClauseNodeModifier {
        private final MatchClauseNode oldNode;
        private SeparatedNodeList<Node> matchPatterns;
        private MatchGuardNode matchGuard;
        private Token rightDoubleArrow;
        private BlockStatementNode blockStatement;

        public MatchClauseNodeModifier(MatchClauseNode oldNode) {
            this.oldNode = oldNode;
            this.matchPatterns = oldNode.matchPatterns();
            this.matchGuard = oldNode.matchGuard().orElse(null);
            this.rightDoubleArrow = oldNode.rightDoubleArrow();
            this.blockStatement = oldNode.blockStatement();
        }

        public MatchClauseNodeModifier withMatchPatterns(SeparatedNodeList<Node> matchPatterns) {
            Objects.requireNonNull(matchPatterns, "matchPatterns must not be null");
            this.matchPatterns = matchPatterns;
            return this;
        }

        public MatchClauseNodeModifier withMatchGuard(MatchGuardNode matchGuard) {
            this.matchGuard = matchGuard;
            return this;
        }

        public MatchClauseNodeModifier withRightDoubleArrow(Token rightDoubleArrow) {
            Objects.requireNonNull(rightDoubleArrow, "rightDoubleArrow must not be null");
            this.rightDoubleArrow = rightDoubleArrow;
            return this;
        }

        public MatchClauseNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public MatchClauseNode apply() {
            return this.oldNode.modify(this.matchPatterns, this.matchGuard, this.rightDoubleArrow, this.blockStatement);
        }
    }
}

