/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class MemberTypeDescriptorNode
extends NonTerminalNode {
    public MemberTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "typeDescriptor"};
    }

    public MemberTypeDescriptorNode modify(NodeList<AnnotationNode> annotations, TypeDescriptorNode typeDescriptor) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), typeDescriptor)) {
            return this;
        }
        return NodeFactory.createMemberTypeDescriptorNode(annotations, typeDescriptor);
    }

    public MemberTypeDescriptorNodeModifier modify() {
        return new MemberTypeDescriptorNodeModifier(this);
    }

    public static class MemberTypeDescriptorNodeModifier {
        private final MemberTypeDescriptorNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private TypeDescriptorNode typeDescriptor;

        public MemberTypeDescriptorNodeModifier(MemberTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.typeDescriptor = oldNode.typeDescriptor();
        }

        public MemberTypeDescriptorNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public MemberTypeDescriptorNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public MemberTypeDescriptorNode apply() {
            return this.oldNode.modify(this.annotations, this.typeDescriptor);
        }
    }
}

