/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import java.util.Objects;
import java.util.Optional;

public class MetadataNode
extends NonTerminalNode {
    public MetadataNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Node> documentationString() {
        return this.optionalChildInBucket(0);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(1));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"documentationString", "annotations"};
    }

    public MetadataNode modify(Node documentationString, NodeList<AnnotationNode> annotations) {
        if (this.checkForReferenceEquality(documentationString, annotations.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createMetadataNode(documentationString, annotations);
    }

    public MetadataNodeModifier modify() {
        return new MetadataNodeModifier(this);
    }

    public static class MetadataNodeModifier {
        private final MetadataNode oldNode;
        private Node documentationString;
        private NodeList<AnnotationNode> annotations;

        public MetadataNodeModifier(MetadataNode oldNode) {
            this.oldNode = oldNode;
            this.documentationString = oldNode.documentationString().orElse(null);
            this.annotations = oldNode.annotations();
        }

        public MetadataNodeModifier withDocumentationString(Node documentationString) {
            this.documentationString = documentationString;
            return this;
        }

        public MetadataNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public MetadataNode apply() {
            return this.oldNode.modify(this.documentationString, this.annotations);
        }
    }
}

