/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class MethodDeclarationNode
extends NonTerminalNode {
    public MethodDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public NodeList<Token> qualifierList() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    public Token functionKeyword() {
        return (Token)this.childInBucket(2);
    }

    public IdentifierToken methodName() {
        return (IdentifierToken)this.childInBucket(3);
    }

    public NodeList<Node> relativeResourcePath() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(4));
    }

    public FunctionSignatureNode methodSignature() {
        return (FunctionSignatureNode)this.childInBucket(5);
    }

    public Token semicolon() {
        return (Token)this.childInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "qualifierList", "functionKeyword", "methodName", "relativeResourcePath", "methodSignature", "semicolon"};
    }

    public MethodDeclarationNode modify(SyntaxKind kind, MetadataNode metadata, NodeList<Token> qualifierList, Token functionKeyword, IdentifierToken methodName, NodeList<Node> relativeResourcePath, FunctionSignatureNode methodSignature, Token semicolon) {
        if (this.checkForReferenceEquality(metadata, qualifierList.underlyingListNode(), functionKeyword, methodName, relativeResourcePath.underlyingListNode(), methodSignature, semicolon)) {
            return this;
        }
        return NodeFactory.createMethodDeclarationNode(kind, metadata, qualifierList, functionKeyword, methodName, relativeResourcePath, methodSignature, semicolon);
    }

    public MethodDeclarationNodeModifier modify() {
        return new MethodDeclarationNodeModifier(this);
    }

    public static class MethodDeclarationNodeModifier {
        private final MethodDeclarationNode oldNode;
        private MetadataNode metadata;
        private NodeList<Token> qualifierList;
        private Token functionKeyword;
        private IdentifierToken methodName;
        private NodeList<Node> relativeResourcePath;
        private FunctionSignatureNode methodSignature;
        private Token semicolon;

        public MethodDeclarationNodeModifier(MethodDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.qualifierList = oldNode.qualifierList();
            this.functionKeyword = oldNode.functionKeyword();
            this.methodName = oldNode.methodName();
            this.relativeResourcePath = oldNode.relativeResourcePath();
            this.methodSignature = oldNode.methodSignature();
            this.semicolon = oldNode.semicolon();
        }

        public MethodDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public MethodDeclarationNodeModifier withQualifierList(NodeList<Token> qualifierList) {
            Objects.requireNonNull(qualifierList, "qualifierList must not be null");
            this.qualifierList = qualifierList;
            return this;
        }

        public MethodDeclarationNodeModifier withFunctionKeyword(Token functionKeyword) {
            Objects.requireNonNull(functionKeyword, "functionKeyword must not be null");
            this.functionKeyword = functionKeyword;
            return this;
        }

        public MethodDeclarationNodeModifier withMethodName(IdentifierToken methodName) {
            Objects.requireNonNull(methodName, "methodName must not be null");
            this.methodName = methodName;
            return this;
        }

        public MethodDeclarationNodeModifier withRelativeResourcePath(NodeList<Node> relativeResourcePath) {
            Objects.requireNonNull(relativeResourcePath, "relativeResourcePath must not be null");
            this.relativeResourcePath = relativeResourcePath;
            return this;
        }

        public MethodDeclarationNodeModifier withMethodSignature(FunctionSignatureNode methodSignature) {
            Objects.requireNonNull(methodSignature, "methodSignature must not be null");
            this.methodSignature = methodSignature;
            return this;
        }

        public MethodDeclarationNodeModifier withSemicolon(Token semicolon) {
            Objects.requireNonNull(semicolon, "semicolon must not be null");
            this.semicolon = semicolon;
            return this;
        }

        public MethodDeclarationNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.metadata, this.qualifierList, this.functionKeyword, this.methodName, this.relativeResourcePath, this.methodSignature, this.semicolon);
        }
    }
}

