/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ServiceDeclarationNode
extends ModuleMemberDeclarationNode {
    public ServiceDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public NodeList<Token> qualifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    public Token serviceKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Optional<TypeDescriptorNode> typeDescriptor() {
        return this.optionalChildInBucket(3);
    }

    public NodeList<Node> absoluteResourcePath() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(4));
    }

    public Token onKeyword() {
        return (Token)this.childInBucket(5);
    }

    public SeparatedNodeList<ExpressionNode> expressions() {
        return new SeparatedNodeList<ExpressionNode>((NonTerminalNode)this.childInBucket(6));
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(7);
    }

    public NodeList<Node> members() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(8));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(9);
    }

    public Optional<Token> semicolonToken() {
        return this.optionalChildInBucket(10);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "qualifiers", "serviceKeyword", "typeDescriptor", "absoluteResourcePath", "onKeyword", "expressions", "openBraceToken", "members", "closeBraceToken", "semicolonToken"};
    }

    public ServiceDeclarationNode modify(MetadataNode metadata, NodeList<Token> qualifiers, Token serviceKeyword, TypeDescriptorNode typeDescriptor, NodeList<Node> absoluteResourcePath, Token onKeyword, SeparatedNodeList<ExpressionNode> expressions, Token openBraceToken, NodeList<Node> members, Token closeBraceToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, qualifiers.underlyingListNode(), serviceKeyword, typeDescriptor, absoluteResourcePath.underlyingListNode(), onKeyword, expressions.underlyingListNode(), openBraceToken, members.underlyingListNode(), closeBraceToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createServiceDeclarationNode(metadata, qualifiers, serviceKeyword, typeDescriptor, absoluteResourcePath, onKeyword, expressions, openBraceToken, members, closeBraceToken, semicolonToken);
    }

    public ServiceDeclarationNodeModifier modify() {
        return new ServiceDeclarationNodeModifier(this);
    }

    public static class ServiceDeclarationNodeModifier {
        private final ServiceDeclarationNode oldNode;
        private MetadataNode metadata;
        private NodeList<Token> qualifiers;
        private Token serviceKeyword;
        private TypeDescriptorNode typeDescriptor;
        private NodeList<Node> absoluteResourcePath;
        private Token onKeyword;
        private SeparatedNodeList<ExpressionNode> expressions;
        private Token openBraceToken;
        private NodeList<Node> members;
        private Token closeBraceToken;
        private Token semicolonToken;

        public ServiceDeclarationNodeModifier(ServiceDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.qualifiers = oldNode.qualifiers();
            this.serviceKeyword = oldNode.serviceKeyword();
            this.typeDescriptor = oldNode.typeDescriptor().orElse(null);
            this.absoluteResourcePath = oldNode.absoluteResourcePath();
            this.onKeyword = oldNode.onKeyword();
            this.expressions = oldNode.expressions();
            this.openBraceToken = oldNode.openBraceToken();
            this.members = oldNode.members();
            this.closeBraceToken = oldNode.closeBraceToken();
            this.semicolonToken = oldNode.semicolonToken().orElse(null);
        }

        public ServiceDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ServiceDeclarationNodeModifier withQualifiers(NodeList<Token> qualifiers) {
            Objects.requireNonNull(qualifiers, "qualifiers must not be null");
            this.qualifiers = qualifiers;
            return this;
        }

        public ServiceDeclarationNodeModifier withServiceKeyword(Token serviceKeyword) {
            Objects.requireNonNull(serviceKeyword, "serviceKeyword must not be null");
            this.serviceKeyword = serviceKeyword;
            return this;
        }

        public ServiceDeclarationNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public ServiceDeclarationNodeModifier withAbsoluteResourcePath(NodeList<Node> absoluteResourcePath) {
            Objects.requireNonNull(absoluteResourcePath, "absoluteResourcePath must not be null");
            this.absoluteResourcePath = absoluteResourcePath;
            return this;
        }

        public ServiceDeclarationNodeModifier withOnKeyword(Token onKeyword) {
            Objects.requireNonNull(onKeyword, "onKeyword must not be null");
            this.onKeyword = onKeyword;
            return this;
        }

        public ServiceDeclarationNodeModifier withExpressions(SeparatedNodeList<ExpressionNode> expressions) {
            Objects.requireNonNull(expressions, "expressions must not be null");
            this.expressions = expressions;
            return this;
        }

        public ServiceDeclarationNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public ServiceDeclarationNodeModifier withMembers(NodeList<Node> members) {
            Objects.requireNonNull(members, "members must not be null");
            this.members = members;
            return this;
        }

        public ServiceDeclarationNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public ServiceDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ServiceDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.qualifiers, this.serviceKeyword, this.typeDescriptor, this.absoluteResourcePath, this.onKeyword, this.expressions, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken);
        }
    }
}

