/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import java.util.Objects;
import java.util.Optional;

public class TypeCastParamNode
extends NonTerminalNode {
    public TypeCastParamNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Optional<Node> type() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "type"};
    }

    public TypeCastParamNode modify(NodeList<AnnotationNode> annotations, Node type) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), type)) {
            return this;
        }
        return NodeFactory.createTypeCastParamNode(annotations, type);
    }

    public TypeCastParamNodeModifier modify() {
        return new TypeCastParamNodeModifier(this);
    }

    public static class TypeCastParamNodeModifier {
        private final TypeCastParamNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Node type;

        public TypeCastParamNodeModifier(TypeCastParamNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.type = oldNode.type().orElse(null);
        }

        public TypeCastParamNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public TypeCastParamNodeModifier withType(Node type) {
            this.type = type;
            return this;
        }

        public TypeCastParamNode apply() {
            return this.oldNode.modify(this.annotations, this.type);
        }
    }
}

