/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.nativeimpl;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import io.ballerina.stdlib.observe.nativeimpl.ObserveNativeImplConstants;
import io.ballerina.stdlib.observe.nativeimpl.Utils;
import java.time.Duration;

public class GaugeInitialize {
    public static void initialize(BObject guage) {
        BArray summaryConfigs = (BArray)guage.get(ObserveNativeImplConstants.STATISTICS_CONFIG_FIELD);
        Gauge.Builder gaugeBuilder = Gauge.builder((String)guage.get(ObserveNativeImplConstants.NAME_FIELD).toString()).description(guage.get(ObserveNativeImplConstants.DESCRIPTION_FIELD).toString()).tags(Utils.toStringMap((BMap)guage.get(ObserveNativeImplConstants.TAGS_FIELD)));
        if (summaryConfigs != null && summaryConfigs.size() > 0) {
            for (int i = 0; i < summaryConfigs.size(); ++i) {
                BMap summaryConfigStruct = (BMap)summaryConfigs.get((long)i);
                StatisticConfig.Builder statisticBuilder = StatisticConfig.builder().expiry(Duration.ofMillis((Long)summaryConfigStruct.get((Object)ObserveNativeImplConstants.EXPIRY_FIELD))).buckets(((Long)summaryConfigStruct.get((Object)ObserveNativeImplConstants.BUCKETS_FIELD)).longValue());
                BArray bFloatArray = (BArray)summaryConfigStruct.get((Object)ObserveNativeImplConstants.PERCENTILES_FIELD);
                double[] percentiles = new double[bFloatArray.size()];
                for (int j = 0; j < bFloatArray.size(); ++j) {
                    percentiles[j] = bFloatArray.getFloat((long)j);
                }
                statisticBuilder.percentiles(percentiles);
                StatisticConfig config = statisticBuilder.build();
                gaugeBuilder.summarize(config);
            }
        }
        Gauge gauge = gaugeBuilder.build();
        guage.addNativeData("__metric_native_instance__", (Object)gauge);
    }
}

