/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.metrics.Counter;
import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.PolledGauge;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.stdlib.observe.nativeimpl.Utils;
import java.util.Set;

public class GetAllMetrics {
    public static BArray getAllMetrics(Environment env) {
        Metric[] metrics = DefaultMetricRegistry.getInstance().getAllMetrics();
        BArray bMetrics = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)Utils.metricType));
        int metricIndex = 0;
        for (Metric metric : metrics) {
            MetricId metricId = metric.getId();
            Number metricValue = null;
            String metricType = null;
            BArray summary = null;
            if (metric instanceof Counter) {
                metricValue = ((Counter)metric).getValue();
                metricType = "counter";
            } else if (metric instanceof Gauge) {
                gauge = (Gauge)metric;
                metricValue = gauge.getValue();
                metricType = "gauge";
                summary = Utils.createBSnapshots(env, gauge.getSnapshots());
            } else if (metric instanceof PolledGauge) {
                gauge = (PolledGauge)metric;
                metricValue = gauge.getValue();
                metricType = "gauge";
            }
            if (metricValue == null) continue;
            BMap metricStruct = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)"Metric");
            metricStruct.put((Object)StringUtils.fromString((String)"name"), (Object)StringUtils.fromString((String)metricId.getName()));
            metricStruct.put((Object)StringUtils.fromString((String)"desc"), (Object)StringUtils.fromString((String)metricId.getDescription()));
            metricStruct.put((Object)StringUtils.fromString((String)"tags"), GetAllMetrics.getTags(metricId));
            metricStruct.put((Object)StringUtils.fromString((String)"metricType"), (Object)StringUtils.fromString((String)metricType));
            metricStruct.put((Object)StringUtils.fromString((String)"value"), (Object)metricValue);
            metricStruct.put((Object)StringUtils.fromString((String)"summary"), (Object)summary);
            bMetrics.add((long)metricIndex, (Object)metricStruct);
            ++metricIndex;
        }
        return bMetrics;
    }

    private static BMap<BString, Object> getTags(MetricId metricId) {
        BMap bTags = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING));
        Set tags = metricId.getTags();
        for (Tag tag : tags) {
            bTags.put((Object)StringUtils.fromString((String)tag.getKey()), (Object)StringUtils.fromString((String)tag.getValue()));
        }
        return bTags;
    }
}

