/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.tracer.BSpan;
import io.ballerina.runtime.observability.tracer.TracersStore;
import io.ballerina.runtime.observability.tracer.TracingUtils;
import io.opentelemetry.api.trace.Tracer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTracerBallerinaWrapper {
    private static final Logger log = LoggerFactory.getLogger(OpenTracerBallerinaWrapper.class);
    private static final OpenTracerBallerinaWrapper instance = new OpenTracerBallerinaWrapper();
    private final TracersStore tracerStore;
    private final boolean enabled;
    private final Map<Long, ObserverContext> observerContextMap = new HashMap<Long, ObserverContext>();
    private final AtomicLong spanIdCounter = new AtomicLong();
    private static final int SYSTEM_TRACE_INDICATOR = -1;
    static final int ROOT_SPAN_INDICATOR = -2;

    private OpenTracerBallerinaWrapper() {
        this.enabled = ObserveUtils.isTracingEnabled();
        this.tracerStore = TracersStore.getInstance();
    }

    public static OpenTracerBallerinaWrapper getInstance() {
        return instance;
    }

    private long startSpan(ObserverContext observerContext, boolean isClient, String spanName) {
        observerContext.setOperationName(spanName);
        TracingUtils.startObservation((ObserverContext)observerContext, (boolean)isClient);
        long spanId = this.spanIdCounter.getAndIncrement();
        this.observerContextMap.put(spanId, observerContext);
        return spanId;
    }

    public long startSpan(Environment env, String spanName, Map<String, String> tags, long parentSpanId) {
        String serviceName;
        if (!this.enabled) {
            return -1L;
        }
        ObserverContext observerContext = new ObserverContext();
        ObserverContext prevObserverContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
        if (prevObserverContext != null) {
            serviceName = prevObserverContext.getServiceName();
            String entrypointFunctionModule = prevObserverContext.getEntrypointFunctionModule();
            String entrypointServiceName = prevObserverContext.getEntrypointServiceName();
            String entrypointFunctionName = prevObserverContext.getEntrypointFunctionName();
            String entrypointResourceAccessor = prevObserverContext.getEntrypointResourceAccessor();
            observerContext.setEntrypointFunctionModule(entrypointFunctionModule);
            observerContext.setEntrypointServiceName(entrypointServiceName);
            observerContext.setEntrypointFunctionName(entrypointFunctionName);
            observerContext.setEntrypointResourceAccessor(entrypointResourceAccessor);
            observerContext.addTag("entrypoint.function.module", entrypointFunctionModule);
            observerContext.addTag("entrypoint.service.name", entrypointServiceName);
            observerContext.addTag("entrypoint.function.name", entrypointFunctionName);
            observerContext.addTag("entrypoint.resource.accessor", entrypointResourceAccessor);
        } else {
            serviceName = "Ballerina";
        }
        observerContext.setServiceName(serviceName);
        Tracer tracer = this.tracerStore.getTracer(serviceName);
        if (tracer == null) {
            return -1L;
        }
        tags.forEach((arg_0, arg_1) -> ((ObserverContext)observerContext).addTag(arg_0, arg_1));
        if (parentSpanId == -1L) {
            observerContext.setSystemSpan(true);
            if (prevObserverContext != null) {
                observerContext.setParent(prevObserverContext);
            }
            ObserveUtils.setObserverContextToCurrentFrame((Environment)env, (ObserverContext)observerContext);
            return this.startSpan(observerContext, true, spanName);
        }
        if (parentSpanId != -2L) {
            ObserverContext parentOContext = this.observerContextMap.get(parentSpanId);
            if (parentOContext == null) {
                return -1L;
            }
            observerContext.setParent(parentOContext);
            return this.startSpan(observerContext, true, spanName);
        }
        return this.startSpan(observerContext, true, spanName);
    }

    public boolean finishSpan(Environment env, long spanId) {
        if (!this.enabled) {
            return false;
        }
        ObserverContext observerContext = this.observerContextMap.get(spanId);
        if (observerContext != null) {
            if (observerContext.isSystemSpan()) {
                ObserveUtils.setObserverContextToCurrentFrame((Environment)env, (ObserverContext)observerContext.getParent());
            }
            TracingUtils.stopObservation((ObserverContext)observerContext);
            observerContext.setFinished();
            this.observerContextMap.remove(spanId);
            return true;
        }
        return false;
    }

    public Object addTag(Environment env, String tagKey, String tagValue, long spanId) {
        BSpan span;
        if (!this.enabled) {
            return null;
        }
        if (spanId == -1L) {
            ObserverContext observer = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
            if (observer == null) {
                return null;
            }
            span = observer.getSpan();
        } else {
            ObserverContext observerContext = this.observerContextMap.get(spanId);
            if (observerContext == null) {
                String errorMsg = "Could not find the trace for given span id. Can not add tag {" + tagKey + ":" + tagValue + "}";
                log.info(errorMsg);
                return ErrorCreator.createError((BString)StringUtils.fromString((String)errorMsg));
            }
            span = observerContext.getSpan();
        }
        span.addTag(tagKey, tagValue);
        return null;
    }
}

