/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.server;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.exception.BallerinaFtpException;
import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.server.FtpListener;
import io.ballerina.stdlib.ftp.transport.impl.RemoteFileSystemConnectorFactoryImpl;
import io.ballerina.stdlib.ftp.transport.server.connector.contract.RemoteFileSystemServerConnector;
import io.ballerina.stdlib.ftp.util.FtpConstants;
import io.ballerina.stdlib.ftp.util.FtpUtil;
import io.ballerina.stdlib.ftp.util.ModuleUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FtpListenerHelper {
    private FtpListenerHelper() {
    }

    public static Object init(Environment env, BObject ftpListener, BMap<BString, Object> serviceEndpointConfig) {
        try {
            Map<String, String> paramMap = FtpListenerHelper.getServerConnectorParamMap(serviceEndpointConfig);
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            FtpListener listener = new FtpListener(env.getRuntime());
            RemoteFileSystemServerConnector serverConnector = fileSystemConnectorFactory.createServerConnector(paramMap, listener);
            ftpListener.addNativeData("serverConnector", (Object)serverConnector);
            ftpListener.addNativeData("serviceEndpointConfig", serviceEndpointConfig);
            return null;
        }
        catch (BallerinaFtpException | RemoteFileSystemConnectorException e) {
            return FtpUtil.createError(e.getMessage(), FtpUtil.findRootCause(e), FtpUtil.ErrorType.Error.errorType());
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object register(BObject ftpListener, BObject service) {
        RemoteFileSystemServerConnector ftpConnector = (RemoteFileSystemServerConnector)ftpListener.getNativeData("serverConnector");
        FtpListener listener = ftpConnector.getFtpListener();
        listener.addService(service);
        Optional<MethodType> methodType = FtpUtil.getOnFileChangeMethod(service);
        if (methodType.isEmpty() || methodType.get().getParameters().length != 2) {
            return null;
        }
        if (listener.getCaller() != null) {
            return null;
        }
        BMap serviceEndpointConfig = (BMap)ftpListener.getNativeData("serviceEndpointConfig");
        BObject caller = FtpListenerHelper.createCaller((BMap<BString, Object>)serviceEndpointConfig);
        if (caller instanceof BError) {
            return caller;
        }
        listener.setCaller(caller);
        return null;
    }

    private static Map<String, String> getServerConnectorParamMap(BMap serviceEndpointConfig) throws BallerinaFtpException {
        HashMap<String, String> params = new HashMap<String, String>(12);
        BMap auth = serviceEndpointConfig.getMapValue(StringUtils.fromString((String)"auth"));
        String url = FtpUtil.createUrl(serviceEndpointConfig);
        params.put("uri", url);
        FtpListenerHelper.addStringProperty(serviceEndpointConfig, params);
        if (auth != null) {
            BMap privateKey = auth.getMapValue(StringUtils.fromString((String)"privateKey"));
            if (privateKey != null) {
                String privateKeyPath = privateKey.getStringValue(StringUtils.fromString((String)"path")).getValue();
                if (privateKeyPath.isEmpty()) {
                    throw FtpUtil.createError("Private key path cannot be empty", null, FtpUtil.ErrorType.Error.errorType());
                }
                params.put("IDENTITY", privateKeyPath);
                String privateKeyPassword = null;
                if (privateKey.containsKey((Object)StringUtils.fromString((String)"password"))) {
                    privateKeyPassword = privateKey.getStringValue(StringUtils.fromString((String)"password")).getValue();
                }
                if (privateKeyPassword != null && !privateKeyPassword.isEmpty()) {
                    params.put("IDENTITY_PASS_PHRASE", privateKeyPassword);
                }
            }
            params.put("preferredMethods", FtpUtil.getPreferredMethodsFromAuthConfig(auth));
        }
        boolean userDirIsRoot = serviceEndpointConfig.getBooleanValue(FtpConstants.USER_DIR_IS_ROOT_FIELD);
        params.put("USER_DIR_IS_ROOT", String.valueOf(userDirIsRoot));
        params.put("AVOID_PERMISSION_CHECK", String.valueOf(true));
        params.put("PASSIVE_MODE", String.valueOf(true));
        return params;
    }

    private static void addStringProperty(BMap config, Map<String, String> params) {
        BString namePatternString = config.getStringValue(StringUtils.fromString((String)"fileNamePattern"));
        String fileNamePattern = namePatternString != null && !namePatternString.getValue().isEmpty() ? namePatternString.getValue() : "";
        params.put("fileNamePattern", fileNamePattern);
    }

    public static Object poll(BObject ftpListener) {
        RemoteFileSystemServerConnector connector = (RemoteFileSystemServerConnector)ftpListener.getNativeData("serverConnector");
        try {
            connector.poll();
        }
        catch (RemoteFileSystemConnectorException e) {
            return FtpUtil.createError("Error during the poll operation: " + e.getMessage(), FtpUtil.findRootCause(e), FtpUtil.ErrorType.Error.errorType());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deregister(BObject ftpListener, BObject service) {
        try {
            RemoteFileSystemServerConnector serverConnector;
            Object stopError;
            Object serverConnectorObject = ftpListener.getNativeData("serverConnector");
            if (serverConnectorObject instanceof RemoteFileSystemServerConnector && (stopError = (serverConnector = (RemoteFileSystemServerConnector)serverConnectorObject).stop()) instanceof BError) {
                Object object = stopError;
                return object;
            }
        }
        catch (RemoteFileSystemConnectorException e) {
            BError bError = FtpUtil.createError(e.getMessage(), FtpUtil.findRootCause(e), FtpUtil.ErrorType.Error.errorType());
            return bError;
        }
        finally {
            ftpListener.addNativeData("serverConnector", null);
        }
        return null;
    }

    private static BObject createCaller(BMap<BString, Object> serviceEndpointConfig) {
        BObject client = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"Client", (Object[])new Object[]{serviceEndpointConfig});
        return ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"Caller", (Object[])new Object[]{client});
    }
}

