/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.transport.message;

import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemBaseMessage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;

public class RemoteFileSystemMessage
extends RemoteFileSystemBaseMessage {
    private ByteBuffer bytes;
    private InputStream inputStream;
    private String text;
    private long size;
    private boolean directory;
    private Map<String, FileInfo> childrenInfo;

    public RemoteFileSystemMessage(Map<String, FileInfo> childrenInfo) {
        this.childrenInfo = Collections.unmodifiableMap(childrenInfo);
    }

    public RemoteFileSystemMessage(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    public RemoteFileSystemMessage(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public RemoteFileSystemMessage(String text) {
        this.text = text;
    }

    public RemoteFileSystemMessage(long size) {
        this.size = size;
    }

    public RemoteFileSystemMessage(boolean isDirectory) {
        this.directory = isDirectory;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getText() {
        return this.text;
    }

    public long getSize() {
        return this.size;
    }

    public String[] getChildNames() {
        return this.childrenInfo.keySet().toArray(new String[this.childrenInfo.keySet().size()]);
    }

    public Map<String, FileInfo> getChildrenInfo() {
        return this.childrenInfo;
    }

    public boolean isDirectory() {
        return this.directory;
    }
}

