/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.transport.server;

import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.server.FtpListener;
import io.ballerina.stdlib.ftp.transport.listener.RemoteFileSystemListener;
import io.ballerina.stdlib.ftp.transport.message.FileInfo;
import io.ballerina.stdlib.ftp.transport.message.RemoteFileSystemEvent;
import io.ballerina.stdlib.ftp.transport.server.util.FileTransportUtils;
import io.ballerina.stdlib.ftp.util.ExcludeCoverageFromGeneratedReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFileSystemConsumer {
    private static final Logger log = LoggerFactory.getLogger(RemoteFileSystemConsumer.class);
    private RemoteFileSystemListener remoteFileSystemListener;
    private String listeningDirURI;
    private FileObject listeningDir;
    private String fileNamePattern = null;
    private List<String> processed = new ArrayList<String>();
    private List<String> current;
    private List<FileInfo> addedFileInfo;

    public RemoteFileSystemConsumer(Map<String, String> fileProperties, RemoteFileSystemListener listener) throws RemoteFileSystemConnectorException {
        this.remoteFileSystemListener = listener;
        this.listeningDirURI = fileProperties.get("uri");
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileSystemOptions fso = FileTransportUtils.attachFileSystemOptions(fileProperties);
            this.listeningDir = fsManager.resolveFile(this.listeningDirURI, fso);
            FileType fileType = this.listeningDir.getType();
            if (fileType != FileType.FOLDER) {
                String errorMsg = "File system server connector is used to listen to a folder. But the given path does not refer to a folder.";
                RemoteFileSystemConnectorException e = new RemoteFileSystemConnectorException(errorMsg);
                this.remoteFileSystemListener.onError(e);
                throw e;
            }
        }
        catch (FileSystemException e) {
            this.remoteFileSystemListener.onError(e);
            throw new RemoteFileSystemConnectorException("Unable to initialize the connection with the server.", e);
        }
        if (fileProperties.get("fileNamePattern") != null) {
            this.fileNamePattern = fileProperties.get("fileNamePattern");
        }
    }

    public void consume() throws RemoteFileSystemConnectorException {
        block14: {
            this.logDebugConsumeStarted();
            try {
                this.listeningDir.refresh();
                boolean isFileExists = this.listeningDir.exists();
                boolean isFileReadable = this.listeningDir.isReadable();
                if (isFileExists && isFileReadable) {
                    this.current = new ArrayList<String>();
                    this.addedFileInfo = new ArrayList<FileInfo>();
                    FileObject[] children = null;
                    try {
                        children = this.listeningDir.getChildren();
                    }
                    catch (FileSystemException ignored) {
                        this.logDebugErrorWhileGetChildrenFromDirListener(ignored);
                    }
                    if (children == null || children.length == 0) {
                        this.logDebugNoChildrenFromDirWhileConsuming();
                        break block14;
                    }
                    this.handleDirectory(children);
                    ArrayList<String> deleted = new ArrayList<String>();
                    if (this.processed.size() != this.current.size()) {
                        Iterator<String> it = this.processed.iterator();
                        while (it.hasNext()) {
                            String fileName = it.next();
                            if (this.current.contains(fileName)) continue;
                            deleted.add(fileName);
                            it.remove();
                        }
                    }
                    try {
                        if (this.addedFileInfo.size() > 0 || deleted.size() > 0) {
                            RemoteFileSystemEvent message = new RemoteFileSystemEvent(this.addedFileInfo, deleted);
                            this.remoteFileSystemListener.onMessage(message);
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        this.remoteFileSystemListener.onError(e);
                    }
                    break block14;
                }
                String errorMsg = String.format("Unable to access or read file or directory :  %s. Reason: %s", FileTransportUtils.maskUrlPassword(this.listeningDirURI), isFileExists ? "The file can not be read!" : "The file does not exist!");
                this.remoteFileSystemListener.onError(new RemoteFileSystemConnectorException(errorMsg));
            }
            catch (FileSystemException e) {
                this.remoteFileSystemListener.onError(e);
                throw new RemoteFileSystemConnectorException("Unable to get details from remote server.", e);
            }
            finally {
                this.closeDirectories();
            }
        }
        this.logDebugConsumeStopped();
    }

    public Object close() {
        this.closeDirectories();
        return this.remoteFileSystemListener.done();
    }

    public FtpListener getFtpListener() {
        return (FtpListener)this.remoteFileSystemListener;
    }

    private void closeDirectories() {
        try {
            if (this.listeningDir != null) {
                this.listeningDir.close();
            }
        }
        catch (FileSystemException e) {
            log.warn("Could not close file at URI: " + FileTransportUtils.maskUrlPassword(this.listeningDirURI), (Throwable)e);
        }
    }

    private void handleDirectory(FileObject[] children) throws FileSystemException {
        for (FileObject child : children) {
            if (this.fileNamePattern != null && !child.getName().getBaseName().matches(this.fileNamePattern)) {
                this.logDebugDirFileNamePatternNotMatchedInDirHandler();
                continue;
            }
            FileType childType = child.getType();
            if (childType == FileType.FOLDER) {
                FileObject[] childFileObject = null;
                try {
                    childFileObject = child.getChildren();
                }
                catch (FileSystemException ignored) {
                    this.logDebugErrorWhileGetChildrenInDirHandler(ignored);
                }
                if (childFileObject == null || childFileObject.length == 0) {
                    this.logDebugNoChildrenFromDirInDirHandler(child);
                    continue;
                }
                this.handleDirectory(childFileObject);
                continue;
            }
            this.current.add(child.getName().getURI());
            this.handleFile(child);
        }
    }

    private void handleFile(FileObject file) throws FileSystemException {
        String path = file.getName().getURI();
        FileInfo info = new FileInfo(path);
        info.setFileSize(file.getContent().getSize());
        info.setLastModifiedTime(file.getContent().getLastModifiedTime());
        info.setFileName(file.getName());
        info.setFolder(file.isFolder());
        info.setFile(file.isFile());
        info.setPublicURIString(file.getPublicURIString());
        info.setFileType(file.getType());
        info.setAttached(file.isAttached());
        info.setContentOpen(file.isContentOpen());
        info.setExecutable(file.isExecutable());
        info.setHidden(file.isHidden());
        info.setReadable(file.isReadable());
        info.setWritable(file.isWriteable());
        info.setUrl(file.getURL());
        this.addedFileInfo.add(info);
        this.processed.add(path);
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugErrorWhileGetChildrenFromDirListener(FileSystemException ignored) {
        if (log.isDebugEnabled()) {
            log.debug("The file does not exist, or is not a folder, or an error has occurred when trying to list the children. File URI : " + FileTransportUtils.maskUrlPassword(this.listeningDirURI), (Throwable)ignored);
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugNoChildrenFromDirWhileConsuming() {
        if (log.isDebugEnabled()) {
            log.debug("Folder at " + FileTransportUtils.maskUrlPassword(this.listeningDirURI) + " is empty.");
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugDirFileNamePatternNotMatchedInDirHandler() {
        if (log.isDebugEnabled()) {
            log.debug("File " + this.listeningDir.getName().getFriendlyURI() + " is not processed because it did not match the specified pattern.");
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugNoChildrenFromDirInDirHandler(FileObject child) {
        if (log.isDebugEnabled()) {
            log.debug("Folder at " + child.getName().getFriendlyURI() + " is empty.");
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugErrorWhileGetChildrenInDirHandler(FileSystemException ignored) {
        if (log.isDebugEnabled()) {
            log.debug("The file does not exist, or is not a folder, or an error has occurred when trying to list the children. File URI : " + FileTransportUtils.maskUrlPassword(this.listeningDirURI), (Throwable)ignored);
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugConsumeStarted() {
        if (log.isDebugEnabled()) {
            log.debug("Thread name: " + Thread.currentThread().getName());
            log.debug("File System Consumer hashcode: " + this.hashCode());
            log.debug("Polling for directory or file: " + FileTransportUtils.maskUrlPassword(this.listeningDirURI));
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private void logDebugConsumeStopped() {
        if (log.isDebugEnabled()) {
            log.debug("End : Scanning directory or file : " + FileTransportUtils.maskUrlPassword(this.listeningDirURI));
        }
    }
}

