/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.transport.server.connector.contractimpl;

import io.ballerina.stdlib.ftp.exception.RemoteFileSystemConnectorException;
import io.ballerina.stdlib.ftp.server.FtpListener;
import io.ballerina.stdlib.ftp.transport.listener.RemoteFileSystemListener;
import io.ballerina.stdlib.ftp.transport.server.RemoteFileSystemConsumer;
import io.ballerina.stdlib.ftp.transport.server.connector.contract.RemoteFileSystemServerConnector;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFileSystemServerConnectorImpl
implements RemoteFileSystemServerConnector {
    private static final Logger log = LoggerFactory.getLogger(RemoteFileSystemServerConnectorImpl.class);
    private RemoteFileSystemConsumer consumer;
    private AtomicBoolean isPollOperationOccupied = new AtomicBoolean(false);

    public RemoteFileSystemServerConnectorImpl(Map<String, String> properties, RemoteFileSystemListener remoteFileSystemListener) throws RemoteFileSystemConnectorException {
        try {
            this.consumer = new RemoteFileSystemConsumer(properties, remoteFileSystemListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new RemoteFileSystemConnectorException("Failed to initialize File server connector.", e);
        }
    }

    @Override
    public void poll() {
        if (this.isPollOperationOccupied.compareAndSet(false, true)) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Poll method invoked.");
                }
                this.consumer.consume();
            }
            catch (Exception e) {
                log.error("Error executing the polling cycle", (Throwable)e);
            }
            finally {
                this.isPollOperationOccupied.set(false);
            }
        } else {
            log.warn("A scheduled email polling job was skipped as the previous job was still processing.");
        }
    }

    @Override
    public Object stop() {
        return this.consumer.close();
    }

    @Override
    public FtpListener getFtpListener() {
        return this.consumer.getFtpListener();
    }
}

