/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.debugadapter.BallerinaStackFrame;
import org.ballerinalang.debugadapter.DebugInstruction;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.JDIEventProcessor;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.breakpoint.BalBreakpoint;
import org.ballerinalang.debugadapter.breakpoint.LogMessage;
import org.ballerinalang.debugadapter.breakpoint.TemplateLogMessage;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.DebugExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.jdi.JDIUtils;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.utils.PackageUtils;
import org.ballerinalang.debugadapter.utils.ServerUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakpointProcessor {
    private final ExecutionContext context;
    private final JDIEventProcessor jdiEventProcessor;
    private final Map<String, LinkedHashMap<Integer, BalBreakpoint>> userBreakpoints = new ConcurrentHashMap<String, LinkedHashMap<Integer, BalBreakpoint>>();
    private static final int BP_EVALUATION_TIMEOUT = 5000;
    private static final Logger LOGGER = LoggerFactory.getLogger(BreakpointProcessor.class);

    public BreakpointProcessor(ExecutionContext context, JDIEventProcessor jdiEventProcessor) {
        this.context = context;
        this.jdiEventProcessor = jdiEventProcessor;
    }

    public Map<String, LinkedHashMap<Integer, BalBreakpoint>> getUserBreakpoints() {
        return this.userBreakpoints;
    }

    public void addSourceBreakpoints(String qualifiedClassName, LinkedHashMap<Integer, BalBreakpoint> breakpoints) {
        this.userBreakpoints.put(qualifiedClassName, breakpoints);
    }

    void processBreakpointEvent(BreakpointEvent bpEvent) {
        ReferenceType bpReference = bpEvent.location().declaringType();
        String qualifiedClassName = PackageUtils.getQualifiedClassName(bpReference);
        Map fileBreakpoints = this.userBreakpoints.get(qualifiedClassName);
        int lineNumber = bpEvent.location().lineNumber();
        if (this.requireStepOut(bpEvent)) {
            this.activateDynamicBreakPoints((int)bpEvent.thread().uniqueID(), DynamicBreakpointMode.CALLER, true);
            this.context.setPrevInstruction(DebugInstruction.STEP_OVER);
            this.context.getDebuggeeVM().resume();
        } else if (this.context.getPrevInstruction() != null && this.context.getPrevInstruction() != DebugInstruction.CONTINUE) {
            this.jdiEventProcessor.notifyStopEvent(bpEvent);
        } else if (fileBreakpoints == null || !fileBreakpoints.containsKey(lineNumber)) {
            this.jdiEventProcessor.notifyStopEvent(bpEvent);
        } else {
            BalBreakpoint balBreakpoint = (BalBreakpoint)fileBreakpoints.get(lineNumber);
            this.processAdvanceBreakpoints(bpEvent, balBreakpoint, lineNumber);
        }
    }

    private void processAdvanceBreakpoints(BreakpointEvent event, BalBreakpoint breakpoint, int lineNumber) {
        String condition = breakpoint.getCondition().isPresent() && !breakpoint.getCondition().get().isBlank() ? breakpoint.getCondition().get() : "";
        Optional<LogMessage> logMessage = breakpoint.getLogMessage();
        if (logMessage.isEmpty() && condition.isEmpty()) {
            this.jdiEventProcessor.notifyStopEvent(event);
            return;
        }
        if (logMessage.isPresent() && condition.isEmpty()) {
            this.printLogMessage(event, logMessage.get(), lineNumber);
            this.context.getDebuggeeVM().resume();
            return;
        }
        CompletableFuture<Boolean> resultFuture = this.evaluateBreakpointCondition(condition, event.thread(), lineNumber);
        try {
            Boolean result = resultFuture.get(5000L, TimeUnit.MILLISECONDS);
            if (result.booleanValue()) {
                if (logMessage.isPresent()) {
                    this.printLogMessage(event, logMessage.get(), lineNumber);
                    this.context.getDebuggeeVM().resume();
                } else {
                    this.jdiEventProcessor.notifyStopEvent(event);
                }
            } else {
                this.context.getDebuggeeVM().resume();
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.context.getOutputLogger().sendErrorOutput(String.format("Warning: Skipping conditional breakpoint at line: %d, due to timeout while evaluating the condition:'%s'.", lineNumber, condition));
            if (logMessage.isPresent()) {
                this.printLogMessage(event, logMessage.get(), lineNumber);
                this.context.getDebuggeeVM().resume();
            }
            this.jdiEventProcessor.notifyStopEvent(event);
        }
    }

    void restoreUserBreakpoints() {
        if (this.context.getDebuggeeVM() == null) {
            return;
        }
        this.context.getEventManager().deleteAllBreakpoints();
        this.context.getDebuggeeVM().allClasses().forEach(ref -> this.activateUserBreakPoints((ReferenceType)ref, false));
    }

    void activateUserBreakPoints(ReferenceType referenceType, boolean shouldNotify) {
        try {
            String qualifiedClassName = PackageUtils.getQualifiedClassName(referenceType);
            if (!this.userBreakpoints.containsKey(qualifiedClassName)) {
                return;
            }
            Map breakpoints = this.userBreakpoints.get(qualifiedClassName);
            for (BalBreakpoint breakpoint : breakpoints.values()) {
                List<Location> locations = referenceType.locationsOfLine(breakpoint.getLine());
                if (locations.isEmpty()) continue;
                Location loc = locations.get(0);
                BreakpointRequest bpReq = this.context.getEventManager().createBreakpointRequest(loc);
                bpReq.enable();
                if (!ServerUtils.supportsBreakpointVerification(this.context) || breakpoint.isVerified()) continue;
                breakpoint.setVerified(true);
                if (!shouldNotify) continue;
                this.notifyBreakPointChangesToClient(breakpoint);
            }
        }
        catch (AbsentInformationException qualifiedClassName) {
        }
        catch (Exception e) {
            LOGGER.error("Error while activating user breakpoints:" + e.getMessage(), (Throwable)e);
        }
    }

    void activateDynamicBreakPoints(int threadId, DynamicBreakpointMode mode, boolean validate) {
        try {
            ThreadReferenceProxyImpl threadReference = this.context.getAdapter().getAllThreads().get(threadId);
            List<StackFrameProxyImpl> jStackFrames = threadReference.frames();
            List<BallerinaStackFrame> validFrames = this.jdiEventProcessor.filterValidBallerinaFrames(jStackFrames);
            if (mode == DynamicBreakpointMode.CURRENT && !validFrames.isEmpty()) {
                Location currentLocation = validFrames.get(0).getJStackFrame().location();
                Optional<Location> prevLocation = this.context.getPrevLocation();
                if (!validate || prevLocation.isEmpty() || !this.isWithinSameSource(currentLocation, prevLocation.get())) {
                    this.context.getEventManager().deleteAllBreakpoints();
                    this.configureBreakpointsForMethod(currentLocation);
                    this.context.setPrevLocation(currentLocation);
                }
                this.context.setPrevLocation(currentLocation);
            }
            if (mode == DynamicBreakpointMode.CALLER && validFrames.size() > 1) {
                this.context.getEventManager().deleteAllBreakpoints();
                for (int frameIndex = 1; frameIndex < validFrames.size(); ++frameIndex) {
                    this.configureBreakpointsForMethod(validFrames.get(frameIndex).getJStackFrame().location());
                }
                this.context.setPrevLocation(validFrames.get(0).getJStackFrame().location());
            }
        }
        catch (JdiProxyException e) {
            LOGGER.error("Error while activating dynamic breakpoints:" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isWithinSameSource(Location currentLocation, Location prevLocation) {
        try {
            return Objects.equals(currentLocation.sourcePath(), prevLocation.sourcePath()) && Objects.equals(currentLocation.method().name(), prevLocation.method().name());
        }
        catch (AbsentInformationException e) {
            return false;
        }
    }

    private void configureBreakpointsForMethod(Location currentLocation) {
        try {
            List<Location> allLocations = currentLocation.method().allLineLocations();
            Optional<Location> firstLocation = allLocations.stream().filter(location -> location.lineNumber() > 0).min(Comparator.comparingInt(Location::lineNumber));
            Optional<Location> lastLocation = allLocations.stream().max(Comparator.comparingInt(Location::lineNumber));
            if (firstLocation.isEmpty() || lastLocation.isEmpty()) {
                return;
            }
            int nextStepPoint = firstLocation.get().lineNumber();
            do {
                boolean bpAlreadyExist;
                List<Location> locations;
                if ((locations = currentLocation.method().locationsOfLine(nextStepPoint)).isEmpty() || locations.get(0).lineNumber() <= firstLocation.get().lineNumber() || (bpAlreadyExist = this.context.getEventManager().breakpointRequests().stream().anyMatch(breakpointRequest -> breakpointRequest.location().equals(locations.get(0))))) continue;
                BreakpointRequest bpReq = this.context.getEventManager().createBreakpointRequest(locations.get(0));
                bpReq.enable();
            } while (++nextStepPoint <= lastLocation.get().lineNumber());
        }
        catch (AbsentInformationException e) {
            LOGGER.error(e.getMessage());
        }
    }

    private CompletableFuture<Boolean> evaluateBreakpointCondition(String expression, ThreadReference threadReference, int lineNumber) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                BExpressionValue evaluatorResult = this.evaluateExpressionSafely(expression, threadReference);
                String condition = evaluatorResult.getStringValue();
                if (evaluatorResult.getType() != BVariableType.BOOLEAN) {
                    String errorMessage = String.format(EvaluationExceptionKind.TYPE_MISMATCH.getReason(), BVariableType.BOOLEAN.getString(), evaluatorResult.getType().getString(), expression);
                    this.context.getOutputLogger().sendErrorOutput(String.format("Warning: Skipping conditional breakpoint at line: %d, due to: %s%s", lineNumber, System.lineSeparator(), errorMessage));
                }
                return condition.equalsIgnoreCase(Boolean.TRUE.toString());
            }
            catch (EvaluationException e) {
                this.context.getOutputLogger().sendErrorOutput(String.format("Warning: Skipping conditional breakpoint at line: %d, due to: %s%s", lineNumber, System.lineSeparator(), e.getMessage()));
                return false;
            }
            catch (Exception e) {
                this.context.getOutputLogger().sendErrorOutput(String.format("Warning: Skipping conditional breakpoint at line: %d, due to an internal error", lineNumber));
                return false;
            }
        });
    }

    void printLogMessage(BreakpointEvent event, LogMessage logMessage, int lineNumber) {
        try {
            if (logMessage instanceof TemplateLogMessage) {
                TemplateLogMessage template = (TemplateLogMessage)logMessage;
                List<String> expressions = template.getExpressions();
                ArrayList<String> evaluationResults = new ArrayList<String>();
                for (String expression : expressions) {
                    evaluationResults.add(this.evaluateExpressionSafely(expression, event.thread()).getStringValue());
                }
                template.resolveInterpolations(evaluationResults);
                this.context.getOutputLogger().sendProgramOutput(template.getMessage());
            } else {
                this.context.getOutputLogger().sendProgramOutput(logMessage.getMessage());
            }
        }
        catch (Exception e) {
            this.context.getOutputLogger().sendErrorOutput(String.format("Warning: Skipping logpoint at line: %d, due to: %s%s", lineNumber, System.lineSeparator(), e.getMessage()));
        }
    }

    private BExpressionValue evaluateExpressionSafely(String expression, ThreadReference threadReference) throws EvaluationException, JdiProxyException {
        JDIUtils.disableJDIRequests(this.context);
        ThreadReferenceProxyImpl thread = this.context.getAdapter().getAllThreads().get((int)threadReference.uniqueID());
        List<BallerinaStackFrame> validFrames = this.jdiEventProcessor.filterValidBallerinaFrames(thread.frames());
        if (validFrames.isEmpty()) {
            throw new IllegalStateException("Failed to use stack frames for evaluation");
        }
        SuspendedContext ctx = new SuspendedContext(this.context, thread, validFrames.get(0).getJStackFrame());
        EvaluationContext evaluationContext = new EvaluationContext(ctx);
        DebugExpressionEvaluator evaluator = new DebugExpressionEvaluator(evaluationContext);
        evaluator.setExpression(expression);
        BExpressionValue evaluationResult = evaluator.evaluate();
        JDIUtils.enableJDIRequests(this.context);
        return evaluationResult;
    }

    private boolean requireStepOut(BreakpointEvent event) {
        try {
            if (this.context.getPrevInstruction() != DebugInstruction.STEP_OVER && this.context.getPrevInstruction() != DebugInstruction.STEP_OUT) {
                return false;
            }
            Location currentLocation = event.location();
            List<Location> allLocations = currentLocation.method().allLineLocations();
            Optional<Location> lastLocation = allLocations.stream().max(Comparator.comparingInt(Location::lineNumber));
            return lastLocation.isPresent() && currentLocation.lineNumber() == lastLocation.get().lineNumber();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void notifyBreakPointChangesToClient(BalBreakpoint balBreakpoint) {
        Breakpoint dapBreakpoint = balBreakpoint.getAsDAPBreakpoint();
        BreakpointEventArguments bpEventArgs = new BreakpointEventArguments();
        bpEventArgs.setBreakpoint(dapBreakpoint);
        bpEventArgs.setReason("changed");
        this.context.getClient().breakpoint(bpEventArgs);
    }

    public static enum DynamicBreakpointMode {
        CURRENT,
        CALLER,
        BOTH;

    }
}

