/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.debugadapter.JBallerinaDebugServer;
import org.ballerinalang.debugadapter.config.ClientConfigHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugExecutionManager {
    private String host;
    private Integer port;
    private VirtualMachine attachedVm;
    private final JBallerinaDebugServer server;
    public static final String LOCAL_HOST = "localhost";
    private static final String SOCKET_CONNECTOR_NAME = "com.sun.jdi.SocketAttach";
    private static final String CONNECTOR_ARGS_HOST = "hostname";
    private static final String CONNECTOR_ARGS_PORT = "port";
    private static final String VALUE_UNKNOWN = "unknown";
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugExecutionManager.class);

    DebugExecutionManager(JBallerinaDebugServer server) {
        this.server = server;
    }

    public boolean isActive() {
        return this.attachedVm != null;
    }

    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    public String getRemoteVMAddress() {
        String host = this.getHost().orElse(VALUE_UNKNOWN);
        String port = this.getPort().map(String::valueOf).orElse(VALUE_UNKNOWN);
        return String.format("%s:%s", host, port);
    }

    public VirtualMachine attach(String hostName, int port) throws IOException, IllegalConnectorArgumentsException {
        return this.attach(hostName, port, 50L, 100);
    }

    public VirtualMachine attach(String hostName, int port, long retryIntervalMs, int maxAttempts) throws IOException, IllegalConnectorArgumentsException {
        AttachingConnector attachingConnector = Bootstrap.virtualMachineManager().attachingConnectors().stream().filter(ac -> ac.name().equals(SOCKET_CONNECTOR_NAME)).findFirst().orElseThrow(() -> new RuntimeException("Unable to locate SocketAttachingConnector"));
        hostName = Objects.isNull(hostName) || hostName.isBlank() ? LOCAL_HOST : hostName;
        Map<String, Connector.Argument> connectorArgs = attachingConnector.defaultArguments();
        connectorArgs.get(CONNECTOR_ARGS_HOST).setValue(hostName);
        connectorArgs.get(CONNECTOR_ARGS_PORT).setValue(String.valueOf(port));
        return this.attachWithRetries(attachingConnector, connectorArgs, retryIntervalMs, maxAttempts);
    }

    private VirtualMachine attachWithRetries(AttachingConnector connector, Map<String, Connector.Argument> args, long retryIntervalMs, int maxAttempts) throws IOException, IllegalConnectorArgumentsException {
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                this.attachedVm = connector.attach(args);
                this.host = args.get(CONNECTOR_ARGS_HOST).value();
                this.port = Integer.parseInt(args.get(CONNECTOR_ARGS_PORT).value());
                if (this.server.getClientConfigHolder().getKind() == ClientConfigHolder.ClientConfigKind.ATTACH_CONFIG) {
                    this.server.getOutputLogger().sendDebugServerOutput(String.format("Connected to the target VM, address: '%s:%s'", this.host, this.port));
                }
                return this.attachedVm;
            }
            catch (IOException e) {
                LOGGER.debug(String.format("Attach attempt %d/%d failed: %s", attempt, maxAttempts, e.getMessage()));
                try {
                    Thread.sleep(retryIntervalMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException("Failed to attach to the target VM.");
    }

    public void reset() {
        this.attachedVm = null;
        this.host = null;
        this.port = null;
    }
}

