/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;

public class DebugOutputLogger {
    private final IDebugProtocolClient client;
    private boolean isCompilationDone;
    private static final String COMPILER_LOG_RUNNING_EXECUTABLE = "Running executable";
    private static final String COMPILER_LOG_RUNNING_TESTS = "Running Tests";

    public DebugOutputLogger(IDebugProtocolClient client) {
        this.client = client;
        this.isCompilationDone = false;
    }

    public void sendProgramOutput(String output) {
        if (DebugOutputLogger.isInternalLog((String)output)) {
            return;
        }
        if (!((String)output).endsWith(System.lineSeparator())) {
            output = (String)output + System.lineSeparator();
        }
        OutputEventArguments outputEventArguments = new OutputEventArguments();
        outputEventArguments.setOutput((String)output);
        outputEventArguments.setCategory("stdout");
        this.client.output(outputEventArguments);
    }

    public void sendConsoleOutput(String output) {
        if (DebugOutputLogger.isInternalLog((String)output)) {
            return;
        }
        if (!((String)output).endsWith(System.lineSeparator())) {
            output = (String)output + System.lineSeparator();
        }
        OutputEventArguments outputArguments = new OutputEventArguments();
        outputArguments.setOutput((String)output);
        if (this.isCompilationDone || DebugOutputLogger.containsBalErrorPrefix((String)output)) {
            outputArguments.setCategory("stderr");
        } else {
            outputArguments.setCategory("console");
        }
        this.client.output(outputArguments);
        if (((String)output).startsWith(COMPILER_LOG_RUNNING_EXECUTABLE) || ((String)output).startsWith(COMPILER_LOG_RUNNING_TESTS)) {
            this.isCompilationDone = true;
        }
    }

    public void sendDebugServerOutput(String output) {
        if (!((String)output).endsWith(System.lineSeparator())) {
            output = (String)output + System.lineSeparator();
        }
        OutputEventArguments outputArguments = new OutputEventArguments();
        outputArguments.setOutput((String)output);
        outputArguments.setCategory("console");
        this.client.output(outputArguments);
    }

    public void sendErrorOutput(String output) {
        if (DebugOutputLogger.isInternalLog((String)output)) {
            return;
        }
        if (!((String)output).endsWith(System.lineSeparator())) {
            output = (String)output + System.lineSeparator();
        }
        OutputEventArguments outputEventArguments = new OutputEventArguments();
        outputEventArguments.setOutput((String)output);
        outputEventArguments.setCategory("stderr");
        this.client.output(outputEventArguments);
    }

    private static boolean containsBalErrorPrefix(String output) {
        return output.startsWith("ERROR") || output.startsWith("error:");
    }

    private static boolean isInternalLog(String output) {
        return output.startsWith("Listening for transport dt_socket") || output.startsWith("Please start the remote debugging client to continue") || output.startsWith("JAVACMD") || output.startsWith("Stream closed");
    }

    public void reset() {
        this.isCompilationDone = false;
    }
}

