/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.breakpoint;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.ballerinalang.debugadapter.breakpoint.LogMessage;
import org.ballerinalang.debugadapter.breakpoint.PlainTextLogMessage;
import org.ballerinalang.debugadapter.breakpoint.TemplateLogMessage;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Source;

public class BalBreakpoint {
    private final int id = nextID.getAndIncrement();
    private final Source source;
    private final int line;
    private String condition;
    private LogMessage logMessage;
    private boolean isVerified;
    private boolean supportsVerification;
    private static final AtomicInteger nextID = new AtomicInteger(0);

    public BalBreakpoint(Source source, int line) {
        this.source = source;
        this.line = line;
        this.isVerified = false;
        this.supportsVerification = false;
    }

    public Integer getLine() {
        return this.line;
    }

    public Source getSource() {
        return this.source;
    }

    public Optional<String> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Optional<LogMessage> getLogMessage() {
        return Optional.ofNullable(this.logMessage);
    }

    public void setLogMessage(String logMessage) {
        if (this.isTemplate(logMessage)) {
            this.logMessage = new TemplateLogMessage(logMessage);
        } else if (logMessage != null && !logMessage.isBlank()) {
            this.logMessage = new PlainTextLogMessage(logMessage);
        }
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public void setVerified(boolean isVerified) {
        this.isVerified = isVerified;
    }

    public Breakpoint getAsDAPBreakpoint() {
        Breakpoint breakpoint = new Breakpoint();
        breakpoint.setId(Integer.valueOf(this.id));
        breakpoint.setLine(Integer.valueOf(this.line));
        breakpoint.setSource(this.source);
        breakpoint.setVerified(!this.supportsVerification || this.isVerified);
        return breakpoint;
    }

    private boolean isTemplate(String logMessage) {
        return logMessage != null && Pattern.compile("\\$\\{[^}]*}").matcher(logMessage).find();
    }

    public void setSupportsVerification(boolean supportsVerification) {
        this.supportsVerification = supportsVerification;
    }
}

