/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.breakpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.debugadapter.breakpoint.LogMessage;

public class TemplateLogMessage
extends LogMessage {
    private final String rawLogMessage;
    private List<String> expressions;
    private List<String> interpolationResults;

    TemplateLogMessage(String message) {
        super(message);
        this.rawLogMessage = message;
        this.extractInterpolations();
    }

    @Override
    public String getMessage() {
        if (this.interpolationResults == null) {
            throw new RuntimeException("expression interpolation results are not loaded");
        }
        return this.message;
    }

    public List<String> getExpressions() {
        return this.expressions;
    }

    public void resolveInterpolations(List<String> evaluationResults) {
        this.interpolationResults = evaluationResults;
        Pattern pattern = Pattern.compile("\\$\\{[^}]*}");
        Matcher matcher = pattern.matcher(this.rawLogMessage);
        AtomicInteger index = new AtomicInteger();
        this.message = matcher.replaceAll(matchResult -> (String)evaluationResults.get(index.getAndIncrement()));
    }

    private void extractInterpolations() {
        ArrayList<String> expressions = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\$\\{[^}]*}").matcher(this.rawLogMessage);
        while (matcher.find()) {
            String expression = matcher.group();
            expressions.add(expression.substring(2, expression.length() - 1));
        }
        this.expressions = expressions;
    }
}

