/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.context;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.resolver.ContextTypeResolver;
import org.ballerinalang.debugadapter.completion.util.CommonUtil;
import org.ballerinalang.debugadapter.completion.util.CompletionUtil;
import org.ballerinalang.debugadapter.completion.util.QNameReferenceUtil;
import org.ballerinalang.debugadapter.completion.util.SymbolUtil;
import org.eclipse.lsp4j.debug.CompletionItem;

public class RemoteMethodCallActionNodeContext {
    public List<CompletionItem> getCompletions(CompletionContext context, RemoteMethodCallActionNode node) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        ContextTypeResolver resolver = new ContextTypeResolver(context);
        Optional expressionType = (Optional)node.expression().apply((NodeTransformer)resolver);
        if (expressionType.isEmpty() || !SymbolUtil.isClient((Symbol)expressionType.get())) {
            return Collections.emptyList();
        }
        if (this.onSuggestClientActions(node, context)) {
            List<MethodSymbol> clientActions = CommonUtil.getClientActions((Symbol)expressionType.get());
            completionItems.addAll(CompletionUtil.getCompletionItemList(clientActions, context));
        } else if (CommonUtil.isInMethodCallParameterContext(context, node).booleanValue() && QNameReferenceUtil.onQualifiedNameIdentifier(context, (Node)node)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> exprEntries = QNameReferenceUtil.getExpressionContextEntries(context, qNameRef);
            List<CompletionItem> items = CompletionUtil.getCompletionItemList(exprEntries, context);
            completionItems.addAll(items);
        }
        ArrayList<CompletionItem> completionItems1 = new ArrayList<CompletionItem>();
        for (CompletionItem completionItem : completionItems) {
            if (completionItems1.contains(completionItem)) continue;
            completionItems1.add(completionItem);
        }
        return completionItems1;
    }

    private boolean onSuggestClientActions(RemoteMethodCallActionNode node, CompletionContext context) {
        int cursor = context.getCursorPositionInTree();
        return node.rightArrowToken().textRange().endOffset() <= cursor && (node.openParenToken().isMissing() || cursor <= node.openParenToken().textRange().startOffset());
    }
}

