/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.util;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.util.CommonUtil;

public final class QNameReferenceUtil {
    private QNameReferenceUtil() {
    }

    public static String getAlias(QualifiedNameReferenceNode qNameRef) {
        String alias = qNameRef.modulePrefix().text();
        return QNameReferenceUtil.getAlias(alias);
    }

    public static String getAlias(String alias) {
        return alias.startsWith("'") ? alias.substring(1) : alias;
    }

    public static List<Symbol> getModuleContent(CompletionContext context, QualifiedNameReferenceNode qNameRef, Predicate<Symbol> predicate) {
        Optional<ModuleSymbol> module = CommonUtil.searchModuleForAlias(context, QNameReferenceUtil.getAlias(qNameRef));
        return module.map(moduleSymbol -> moduleSymbol.allSymbols().stream().filter(predicate).toList()).orElseGet(ArrayList::new);
    }

    public static boolean onQualifiedNameIdentifier(CompletionContext context, Node node) {
        if (node.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !(node instanceof QualifiedNameReferenceNode)) {
            return false;
        }
        QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)node;
        int colonPos = qNameRef.colon().textRange().startOffset();
        int cursor = context.getCursorPositionInTree();
        return colonPos < cursor && (qNameRef.identifier().isMissing() || cursor <= qNameRef.identifier().textRange().endOffset());
    }

    public static List<Symbol> getExpressionContextEntries(CompletionContext ctx, QualifiedNameReferenceNode qNameRef) {
        return QNameReferenceUtil.getExpressionContextEntries(ctx, qNameRef.modulePrefix().text());
    }

    public static List<Symbol> getExpressionContextEntries(CompletionContext ctx, String moduleAlias) {
        String alias = QNameReferenceUtil.getAlias(moduleAlias);
        Optional<ModuleSymbol> moduleSymbol = CommonUtil.searchModuleForAlias(ctx, alias);
        return moduleSymbol.map(value -> value.allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS || symbol instanceof VariableSymbol).toList()).orElseGet(ArrayList::new);
    }
}

