/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.Symbol;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.EvaluationTypeResolver;
import org.ballerinalang.debugadapter.utils.PackageUtils;

public class NameBasedTypeResolver
extends EvaluationTypeResolver<String> {
    static final String ARRAY_TYPE_SUFFIX = "\\[]$";
    private static final String UNION_TYPE_SEPARATOR_REGEX = "\\|";
    private static final String QUALIFIED_NAME_REF_SEPARATOR = ":";

    public NameBasedTypeResolver(EvaluationContext context) {
        super(context);
    }

    @Override
    public List<Value> resolve(String typeDescriptor) throws EvaluationException {
        LinkedList<Value> resolvedTypes = new LinkedList<Value>();
        if (typeDescriptor.contains(UNION_TYPE_SEPARATOR_REGEX)) {
            String[] unionTypes;
            for (String typeName : unionTypes = typeDescriptor.split(UNION_TYPE_SEPARATOR_REGEX)) {
                resolvedTypes.add(this.resolveSingleType(typeName.trim()));
            }
        } else {
            resolvedTypes.add(this.resolveSingleType(typeDescriptor.trim()));
        }
        return resolvedTypes;
    }

    private Value resolveSingleType(String typeName) throws EvaluationException {
        Optional<Value> result;
        boolean arrayTypeDetected = false;
        if (typeName.endsWith(ARRAY_TYPE_SUFFIX)) {
            arrayTypeDetected = true;
            typeName = typeName.replaceAll(ARRAY_TYPE_SUFFIX, "");
        }
        if ((result = this.resolveInbuiltType(typeName)).isEmpty()) {
            if (typeName.contains(QUALIFIED_NAME_REF_SEPARATOR)) {
                String[] nameRefParts = typeName.split(QUALIFIED_NAME_REF_SEPARATOR);
                result = this.resolveQualifiedType(nameRefParts[0].trim(), nameRefParts[1].trim());
            } else {
                result = this.resolveUserDefinedType(typeName);
            }
        }
        if (result.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, typeName);
        }
        return arrayTypeDetected ? this.createBArrayType(result.get()) : result.get();
    }

    private Optional<Value> resolveUserDefinedType(String typeName) {
        Optional<Symbol> typeDefinition = this.getModuleTypeDefinitionSymbol(typeName);
        if (typeDefinition.isEmpty()) {
            return Optional.empty();
        }
        String packageInitClass = PackageUtils.getQualifiedClassName(this.context, "$_init");
        List<ReferenceType> classRef = this.context.getAttachedVm().classesByName(packageInitClass);
        if (classRef.isEmpty()) {
            return Optional.empty();
        }
        Field typeField = classRef.get(0).fieldByName("$type$" + typeName);
        if (typeField == null) {
            return Optional.empty();
        }
        return Optional.of(classRef.get(0).getValue(typeField));
    }
}

