/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import com.sun.jdi.Method;
import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.InvocationArgProcessor;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;

public class NodeBasedArgProcessor
extends InvocationArgProcessor {
    private final FunctionDefinitionNode definitionNode;

    public NodeBasedArgProcessor(SuspendedContext context, String functionName, Method jdiMethodReference, FunctionDefinitionNode definitionNode) {
        super(context, functionName, jdiMethodReference);
        this.definitionNode = definitionNode;
    }

    @Override
    public List<Value> process(List<Map.Entry<String, Evaluator>> argEvaluators) throws EvaluationException {
        boolean namedArgsFound = false;
        boolean restArgsFound = false;
        boolean restArgsProcessed = false;
        Value restArrayType = null;
        String restParamName = null;
        String restParamTypeName = null;
        ArrayList<Value> restValues = new ArrayList<Value>();
        ArrayList<ParameterNode> params = new ArrayList<ParameterNode>();
        HashMap<String, ParameterNode> remainingParams = new HashMap<String, ParameterNode>();
        if (!this.definitionNode.functionSignature().parameters().isEmpty()) {
            for (ParameterNode paramNode : this.definitionNode.functionSignature().parameters()) {
                params.add(paramNode);
                remainingParams.put(NodeBasedArgProcessor.getParameterName(paramNode), paramNode);
            }
        }
        HashMap<String, Value> argValues = new HashMap<String, Value>();
        int paramIndex = 0;
        for (int argIndex = 0; argIndex < argEvaluators.size(); ++argIndex) {
            Map.Entry<String, Evaluator> arg = argEvaluators.get(argIndex);
            InvocationArgProcessor.ArgType argType = NodeBasedArgProcessor.getArgType(arg);
            if (argType == InvocationArgProcessor.ArgType.POSITIONAL) {
                if (namedArgsFound) {
                    throw EvaluationException.createEvaluationException("positional args are not allowed after named args.");
                }
                if (remainingParams.isEmpty() && restArgsFound) {
                    throw EvaluationException.createEvaluationException("too many arguments in call to '" + this.functionName + "'.");
                }
                BExpressionValue argValue = arg.getValue().evaluate();
                Value jdiArgValue = argValue.getJdiValue();
                if (NodeBasedArgProcessor.getParameterTypeName((ParameterNode)params.get(paramIndex)).equals(BVariableType.ANY.getString())) {
                    jdiArgValue = EvaluationUtils.getValueAsObject(this.context, jdiArgValue);
                }
                if (((ParameterNode)params.get(paramIndex)).kind() == SyntaxKind.REST_PARAM) {
                    Value elementType;
                    for (Map.Entry entry : remainingParams.entrySet()) {
                        SyntaxKind parameterType = ((ParameterNode)entry.getValue()).kind();
                        if (parameterType != SyntaxKind.REST_PARAM) continue;
                        restParamName = (String)entry.getKey();
                        restParamTypeName = ((RestParameterNode)entry.getValue()).typeName().toSourceCode().trim();
                        break;
                    }
                    if (restParamName == null) {
                        throw EvaluationException.createEvaluationException("undefined rest parameter.");
                    }
                    if (!restArgsFound) {
                        restArrayType = NodeBasedArgProcessor.resolveType(this.context, restParamTypeName);
                        restArgsFound = true;
                    }
                    if (!EvaluationUtils.checkIsType(this.context, jdiArgValue, elementType = NodeBasedArgProcessor.getElementType(this.context, restArrayType))) {
                        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_MISMATCH, restParamTypeName.replaceAll("\\[]$", ""), argValue.getType().getString(), restParamName);
                    }
                    restValues.add(jdiArgValue);
                    remainingParams.remove(restParamName);
                    continue;
                }
                String parameterName = NodeBasedArgProcessor.getParameterName((ParameterNode)params.get(paramIndex));
                argValues.put(parameterName, jdiArgValue);
                remainingParams.remove(parameterName);
                ++paramIndex;
                continue;
            }
            if (argType == InvocationArgProcessor.ArgType.NAMED) {
                if (restArgsFound) {
                    throw EvaluationException.createEvaluationException("named args are not allowed after rest args.");
                }
                String argName = arg.getKey();
                if (!remainingParams.containsKey(argName)) {
                    throw EvaluationException.createEvaluationException("undefined parameter '" + argName + "'.");
                }
                namedArgsFound = true;
                Value argValue = arg.getValue().evaluate().getJdiValue();
                if (NodeBasedArgProcessor.getParameterTypeName((ParameterNode)params.get(paramIndex)).equals(BVariableType.ANY.getString())) {
                    argValue = EvaluationUtils.getValueAsObject(this.context, argValue);
                }
                argValues.put(argName, argValue);
                remainingParams.remove(argName);
                ++paramIndex;
                continue;
            }
            if (argType != InvocationArgProcessor.ArgType.REST) continue;
            if (namedArgsFound) {
                throw EvaluationException.createEvaluationException("rest args are not allowed after named args.");
            }
            for (Map.Entry entry : remainingParams.entrySet()) {
                SyntaxKind parameterType = ((ParameterNode)entry.getValue()).kind();
                if (parameterType != SyntaxKind.REST_PARAM) continue;
                restParamName = (String)entry.getKey();
                restParamTypeName = ((RestParameterNode)entry.getValue()).typeName().toSourceCode().trim();
                break;
            }
            if (restParamName == null) {
                throw EvaluationException.createEvaluationException("undefined rest parameter.");
            }
            restArgsFound = true;
            argValues.put(restParamName, arg.getValue().evaluate().getJdiValue());
            remainingParams.remove(restParamName);
            restArgsProcessed = true;
            ++paramIndex;
        }
        for (Map.Entry entry : remainingParams.entrySet()) {
            String paramName = (String)entry.getKey();
            SyntaxKind parameterType = ((ParameterNode)entry.getValue()).kind();
            if (parameterType == SyntaxKind.REQUIRED_PARAM) {
                throw EvaluationException.createEvaluationException("missing required parameter '" + paramName + "'.");
            }
            if (parameterType == SyntaxKind.DEFAULTABLE_PARAM) {
                argValues.put(paramName + "[Defaultable]", VMUtils.make(this.context, 0).getJdiValue());
                continue;
            }
            if (parameterType != SyntaxKind.REST_PARAM) continue;
            restParamTypeName = ((RestParameterNode)entry.getValue()).typeName().toSourceCode().trim();
            restArrayType = NodeBasedArgProcessor.resolveType(this.context, restParamTypeName);
            argValues.put(paramName, NodeBasedArgProcessor.getRestArgArray(this.context, restArrayType, new Value[0]));
            restArgsProcessed = true;
        }
        if (restArgsFound && !restArgsProcessed) {
            argValues.put(restParamName, NodeBasedArgProcessor.getRestArgArray(this.context, restArrayType, restValues.toArray(new Value[0])));
        }
        return this.getOrderedArgList(argValues, null, this.definitionNode);
    }

    private static String getParameterTypeName(ParameterNode parameterNode) {
        return switch (parameterNode.kind()) {
            case SyntaxKind.REQUIRED_PARAM -> ((RequiredParameterNode)parameterNode).typeName().toSourceCode().trim();
            case SyntaxKind.DEFAULTABLE_PARAM -> ((DefaultableParameterNode)parameterNode).typeName().toSourceCode().trim();
            case SyntaxKind.REST_PARAM -> ((RestParameterNode)parameterNode).typeName().toSourceCode().trim();
            default -> "unknown";
        };
    }

    static String getParameterName(ParameterNode parameterNode) {
        Optional paramNameToken = switch (parameterNode.kind()) {
            case SyntaxKind.REQUIRED_PARAM -> ((RequiredParameterNode)parameterNode).paramName();
            case SyntaxKind.DEFAULTABLE_PARAM -> ((DefaultableParameterNode)parameterNode).paramName();
            case SyntaxKind.REST_PARAM -> ((RestParameterNode)parameterNode).paramName();
            default -> Optional.empty();
        };
        return paramNameToken.map(Token::text).orElse("unknown");
    }
}

