/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import java.util.LinkedList;
import java.util.List;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.NameBasedTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class BuiltinSimpleNameReferenceEvaluator
extends Evaluator {
    private final String typeName;

    public BuiltinSimpleNameReferenceEvaluator(EvaluationContext context, BuiltinSimpleNameReferenceNode node) {
        super(context);
        this.typeName = node.name().text().trim();
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        NameBasedTypeResolver builtInTypeResolver = new NameBasedTypeResolver(this.evaluationContext);
        List<Value> resolvedTypes = builtInTypeResolver.resolve(this.typeName);
        if (resolvedTypes.size() != 1) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NAME_REF_RESOLVING_ERROR, this.typeName);
        }
        Value type = resolvedTypes.get(0);
        LinkedList<String> argTypeNames = new LinkedList<String>();
        argTypeNames.add("io.ballerina.runtime.api.types.Type");
        RuntimeStaticMethod createTypedescMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.creators.ValueCreator", "createTypedescValue", argTypeNames);
        LinkedList<Value> argValues = new LinkedList<Value>();
        argValues.add(type);
        createTypedescMethod.setArgValues(argValues);
        return new BExpressionValue(this.context, createTypedescMethod.invokeSafely());
    }
}

