/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.ClassDefinitionResolver;
import org.ballerinalang.debugadapter.evaluation.engine.EvaluationTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.SymbolBasedArgProcessor;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class NewExpressionEvaluator
extends Evaluator {
    private final ExpressionNode syntaxNode;
    private final List<Map.Entry<String, Evaluator>> argEvaluators;
    private static final String OBJECT_INIT_METHOD_NAME = "init";

    public NewExpressionEvaluator(EvaluationContext context, ExpressionNode newExpressionNode, List<Map.Entry<String, Evaluator>> argEvaluators) {
        super(context);
        this.syntaxNode = newExpressionNode;
        this.argEvaluators = argEvaluators;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            if (this.syntaxNode instanceof ImplicitNewExpressionNode) {
                throw EvaluationException.createEvaluationException("Implicit new expressions are not supported by the evaluator. Try using the equivalent explicit expression by specifying the class descriptor (i.e. 'new T()') instead.");
            }
            Value value = this.invokeObjectInitMethod(((ExplicitNewExpressionNode)this.syntaxNode).typeDescriptor());
            return new BExpressionValue(this.context, value);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private Value invokeObjectInitMethod(TypeDescriptorNode classType) throws EvaluationException {
        Optional<ClassSymbol> classSymbol;
        String className;
        Optional<Object> modulePrefix;
        if (classType.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            modulePrefix = Optional.of(((QualifiedNameReferenceNode)classType).modulePrefix().text().trim());
            className = ((QualifiedNameReferenceNode)classType).identifier().text().trim();
        } else {
            className = classType.toSourceCode().trim();
            modulePrefix = Optional.empty();
        }
        className = IdentifierModifier.decodeIdentifier(className);
        ClassDefinitionResolver classDefResolver = new ClassDefinitionResolver(this.context);
        if (modulePrefix.isPresent()) {
            ModuleSymbol importedModule = ((BImport)this.resolvedImports.get(modulePrefix.get())).getResolvedSymbol();
            classSymbol = classDefResolver.findBalClassDefWithinModule(importedModule, className);
        } else {
            classSymbol = classDefResolver.findBalClassDefWithinModule(className);
        }
        if (classSymbol.isEmpty()) {
            if (modulePrefix.isPresent()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_CLASS, className, modulePrefix.get());
            }
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, classType.toSourceCode().trim());
        }
        if (!EvaluationTypeResolver.isPublicSymbol((Symbol)classSymbol.get())) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_ACCESS, classType.toSourceCode().trim());
        }
        ModuleID moduleId = ((ModuleSymbol)classSymbol.get().getModule().get()).id();
        Optional initMethodRef = classSymbol.get().initMethod();
        if (initMethodRef.isEmpty() && !this.argEvaluators.isEmpty()) {
            throw EvaluationException.createEvaluationException("too many arguments in call to 'init'.");
        }
        ArrayList<String> argTypeNames = new ArrayList<String>();
        argTypeNames.add("java.lang.String");
        argTypeNames.add("java.lang.String");
        argTypeNames.add("java.lang.String");
        argTypeNames.add("java.lang.String");
        argTypeNames.add("java.lang.Object[]");
        RuntimeStaticMethod createObjectMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "createObjectValue", argTypeNames);
        if (initMethodRef.isEmpty()) {
            throw EvaluationException.createEvaluationException(String.format("failed to resolve the '%s' method definition of '%s'.", OBJECT_INIT_METHOD_NAME, className));
        }
        ArrayList<Value> argValues = new ArrayList<Value>();
        argValues.add(EvaluationUtils.getAsJString(this.context, moduleId.orgName()));
        argValues.add(EvaluationUtils.getAsJString(this.context, moduleId.moduleName()));
        argValues.add(EvaluationUtils.getAsJString(this.context, moduleId.version().split("\\.")[0]));
        argValues.add(EvaluationUtils.getAsJString(this.context, className));
        SymbolBasedArgProcessor argProcessor = new SymbolBasedArgProcessor(this.context, OBJECT_INIT_METHOD_NAME, createObjectMethod.getJDIMethodRef(), (FunctionSymbol)initMethodRef.get());
        List<Value> userArgs = argProcessor.process(this.argEvaluators);
        argValues.addAll(userArgs);
        createObjectMethod.setArgValues(argValues);
        return createObjectMethod.invokeSafely();
    }
}

