/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class TypeOfExpressionEvaluator
extends Evaluator {
    private final TypeofExpressionNode syntaxNode;
    private final Evaluator exprEvaluator;

    public TypeOfExpressionEvaluator(EvaluationContext context, TypeofExpressionNode typeofExpressionNode, Evaluator exprEvaluator) {
        super(context);
        this.syntaxNode = typeofExpressionNode;
        this.exprEvaluator = exprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue result = this.exprEvaluator.evaluate();
            Value bTypeValue = TypeOfExpressionEvaluator.getBTypeOf(this.context, result.getJdiValue());
            return new BExpressionValue(this.context, bTypeValue);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    public static Value getBTypeOf(SuspendedContext context, Value bValue) throws EvaluationException {
        Value valueAsObject = EvaluationUtils.getValueAsObject(context, bValue);
        List<String> methodArgTypeNames = Collections.singletonList("java.lang.Object");
        RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(context, "io.ballerina.runtime.internal.TypeChecker", "getTypedesc", methodArgTypeNames);
        method.setArgValues(Collections.singletonList(valueAsObject));
        return method.invokeSafely();
    }
}

