/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.utils;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public final class VariableUtils {
    public static Optional<BExpressionValue> getModuleVariable(SuspendedContext context, ModuleSymbol moduleSymbol, String nameReference) {
        String classQName = VariableUtils.getInitClassName(moduleSymbol);
        return VariableUtils.getFieldValue(context, classQName, nameReference);
    }

    public static String getMapType(SuspendedContext context, Value mapValue) {
        try {
            RuntimeStaticMethod getBMapType = EvaluationUtils.getRuntimeMethod(context, "org.ballerinalang.debugadapter.runtime.VariableUtils", "getBMapType", Collections.singletonList("java.lang.Object"));
            getBMapType.setArgValues(Collections.singletonList(mapValue));
            Value value = getBMapType.invokeSafely();
            return org.ballerinalang.debugadapter.variable.VariableUtils.getStringFrom(value);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private static String getInitClassName(ModuleSymbol moduleSymbol) {
        StringJoiner classNameJoiner = new StringJoiner(".");
        classNameJoiner.add(moduleSymbol.id().orgName()).add(IdentifierModifier.encodeModuleName(moduleSymbol.id().moduleName())).add(moduleSymbol.id().version().split("\\.")[0]).add("$_init");
        return classNameJoiner.toString();
    }

    private static Optional<BExpressionValue> getFieldValue(SuspendedContext context, String qualifiedClassName, String fieldName) {
        List<ReferenceType> classesRef = context.getAttachedVm().classesByName(qualifiedClassName);
        if (classesRef == null || classesRef.isEmpty()) {
            try {
                classesRef = Collections.singletonList(EvaluationUtils.loadClass(context, qualifiedClassName, ""));
            }
            catch (EvaluationException e) {
                return Optional.empty();
            }
        }
        if (classesRef.size() != 1) {
            return Optional.empty();
        }
        Field field = classesRef.get(0).fieldByName(fieldName);
        if (field == null) {
            return Optional.empty();
        }
        return Optional.of(new BExpressionValue(context, classesRef.get(0).getValue(field)));
    }

    private VariableUtils() {
    }
}

