/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.validator;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.parser.DebugParser;
import org.ballerinalang.debugadapter.evaluation.parser.DebugParserException;
import org.ballerinalang.debugadapter.evaluation.parser.ExpressionParser;
import org.ballerinalang.debugadapter.evaluation.validator.Validator;
import org.ballerinalang.debugadapter.evaluation.validator.ValidatorException;
import org.ballerinalang.debugadapter.evaluation.validator.impl.ExpressionValidator;
import org.ballerinalang.debugadapter.evaluation.validator.impl.InvalidInputValidator;
import org.ballerinalang.debugadapter.evaluation.validator.impl.StatementValidator;
import org.ballerinalang.debugadapter.evaluation.validator.impl.TopLevelDeclarationValidator;

public class SerialExpressionValidator
extends Validator {
    private ExpressionValidator expressionValidator = null;
    private List<Validator> otherValidators = null;

    public SerialExpressionValidator() {
        super(new DebugParser());
    }

    public ExpressionNode validateAndParse(String source) throws Exception {
        this.validate(source);
        SyntaxTree cachedTree = this.expressionValidator.getDebugParser().getSyntaxTreeFor(source);
        return this.expressionValidator.getExpressionNodeFrom(cachedTree);
    }

    @Override
    public void validate(String source) throws Exception {
        this.loadValidators();
        try {
            this.expressionValidator.validate(source);
        }
        catch (DebugParserException | ValidatorException e) {
            this.fallBackOnOtherValidators(source);
            throw EvaluationException.createEvaluationException(e.getMessage());
        }
        catch (Exception e) {
            this.fallBackOnOtherValidators(source);
            throw EvaluationException.createEvaluationException("expression validation failed due to: " + e.getMessage());
        }
    }

    private void fallBackOnOtherValidators(String source) throws EvaluationException {
        for (Validator validator : this.otherValidators) {
            try {
                validator.validate(source);
            }
            catch (DebugParserException | ValidatorException e) {
                throw EvaluationException.createEvaluationException(e.getMessage());
            }
            catch (Exception e) {
                throw EvaluationException.createEvaluationException("expression validation failed due to: " + e.getMessage());
            }
        }
    }

    private void loadValidators() {
        this.expressionValidator = new ExpressionValidator(new ExpressionParser());
        this.otherValidators = new ArrayList<Validator>();
        this.otherValidators.add(new InvalidInputValidator(this.debugParser));
        this.otherValidators.add(new TopLevelDeclarationValidator(this.debugParser));
        this.otherValidators.add(new StatementValidator());
    }
}

