/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.validator.impl;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.parser.ExpressionParser;
import org.ballerinalang.debugadapter.evaluation.validator.ValidatorException;
import org.ballerinalang.debugadapter.evaluation.validator.impl.StatementValidator;

public class ExpressionValidator
extends StatementValidator {
    public ExpressionValidator() {
        this(new ExpressionParser());
    }

    public ExpressionValidator(ExpressionParser parser) {
        super(parser);
    }

    @Override
    public void validate(String source) throws Exception {
        SyntaxTree syntaxTree = this.debugParser.getSyntaxTreeFor(source);
        NodeList<StatementNode> statements = ExpressionValidator.getStatementsFrom(syntaxTree);
        StatementNode exprStatement = (StatementNode)statements.get(0);
        ExpressionValidator.failIf(exprStatement.kind() != SyntaxKind.RETURN_STATEMENT, "Statement evaluation is not supported.");
        Optional expression = ((ReturnStatementNode)exprStatement).expression();
        ExpressionValidator.failIf(expression.isEmpty(), "Failed to derive the expression due to a parsing error.");
        if (syntaxTree.hasDiagnostics()) {
            StringJoiner errors = new StringJoiner(System.lineSeparator());
            syntaxTree.diagnostics().forEach(diagnostic -> {
                if (diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR) {
                    errors.add(diagnostic.message());
                }
            });
            ExpressionValidator.failIf(errors.length() > 0, String.format(EvaluationExceptionKind.SYNTAX_ERROR.getReason(), errors));
        }
    }

    public ExpressionNode getExpressionNodeFrom(SyntaxTree syntaxTree) throws ValidatorException {
        NodeList<StatementNode> statements = ExpressionValidator.getStatementsFrom(syntaxTree);
        StatementNode exprStatement = (StatementNode)statements.get(0);
        return (ExpressionNode)((ReturnStatementNode)exprStatement).expression().get();
    }
}

