/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.jdi;

import com.sun.jdi.ThreadGroupReference;
import java.util.List;
import org.ballerinalang.debugadapter.jdi.ObjectReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadGroupReferenceProxy;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadGroupReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadGroupReferenceProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadGroupReferenceProxyImpl.class);
    private ThreadGroupReferenceProxyImpl myParentThreadGroupProxy;
    private boolean myIsParentGroupCached = false;
    private String myName;

    public ThreadGroupReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadGroupReference threadGroupReference) {
        super(virtualMachineProxy, threadGroupReference);
    }

    @Override
    public ThreadGroupReference getThreadGroupReference() {
        return (ThreadGroupReference)this.getObjectReference();
    }

    public String name() {
        this.checkValid();
        if (this.myName == null) {
            this.myName = this.getThreadGroupReference().name();
        }
        return this.myName;
    }

    public ThreadGroupReferenceProxyImpl parent() {
        this.checkValid();
        if (!this.myIsParentGroupCached) {
            this.myParentThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(this.getThreadGroupReference().parent());
            this.myIsParentGroupCached = true;
        }
        return this.myParentThreadGroupProxy;
    }

    @Override
    public String toString() {
        return "ThreadGroupReferenceProxy: " + this.getThreadGroupReference().toString();
    }

    public void suspend() {
        this.getThreadGroupReference().suspend();
    }

    public void resume() {
        this.getThreadGroupReference().resume();
    }

    public List<ThreadReferenceProxyImpl> threads() {
        return this.getThreadGroupReference().threads().stream().map(this.getVirtualMachineProxy()::getThreadReferenceProxy).toList();
    }

    public List<ThreadGroupReferenceProxyImpl> threadGroups() {
        return this.getThreadGroupReference().threadGroups().stream().map(this.getVirtualMachineProxy()::getThreadGroupReferenceProxy).toList();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

