/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.ballerinalang.debugadapter.jdi.ClassesByNameProvider;
import org.ballerinalang.debugadapter.jdi.JdiTimer;
import org.ballerinalang.debugadapter.jdi.ObjectReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.StringReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadGroupReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreeState;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualMachineProxyImpl.class);
    private final VirtualMachine myVirtualMachine;
    private int myTimeStamp = 0;
    private int myPausePressedCount = 0;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> myObjectReferenceProxies = new HashMap<ObjectReference, ObjectReferenceProxyImpl>();
    private final Map<String, StringReference> myStringLiteralCache = new HashMap<String, StringReference>();
    private final Map<ThreadReference, ThreadReferenceProxyImpl> myAllThreads = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> myThreadGroups = new HashMap<ThreadGroupReference, ThreadGroupReferenceProxyImpl>();
    private boolean myAllThreadsDirty = true;
    private List<ReferenceType> myAllClasses;
    private Map<ReferenceType, List<ReferenceType>> myNestedClassesCache = new HashMap<ReferenceType, List<ReferenceType>>();
    public final Throwable mySuspendLogger = new Throwable();
    private final boolean myVersionHigher15;
    private final boolean myVersionHigher14;
    private final Capability myWatchFielsModification = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canWatchFieldModification();
        }
    };
    private final Capability myWatchFieldAccess = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canWatchFieldAccess();
        }
    };
    private final Capability myIsJ2ME = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.isJ2ME();
        }
    };
    private final Capability myGetBytecodes = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetBytecodes();
        }
    };
    private final Capability myGetConstantPool = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetConstantPool();
        }
    };
    private final Capability myGetSyntheticAttribute = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetSyntheticAttribute();
        }
    };
    private final Capability myGetOwnedMonitorInfo = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetOwnedMonitorInfo();
        }
    };
    private final Capability myGetMonitorFrameInfo = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetMonitorFrameInfo();
        }
    };
    private final Capability myGetCurrentContendedMonitor = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetCurrentContendedMonitor();
        }
    };
    private final Capability myGetMonitorInfo = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canGetMonitorInfo();
        }
    };
    private final Capability myUseInstanceFilters = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canUseInstanceFilters();
        }
    };
    private final Capability myRedefineClasses = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canRedefineClasses();
        }
    };
    private final Capability myAddMethod = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canAddMethod();
        }
    };
    private final Capability myUnrestrictedlyRedefineClasses = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canUnrestrictedlyRedefineClasses();
        }
    };
    private final Capability myPopFrames = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canPopFrames();
        }
    };
    private final Capability myForceEarlyReturn = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVirtualMachine.canForceEarlyReturn();
        }
    };
    private final Capability myCanGetInstanceInfo = new Capability(){

        @Override
        protected boolean calcValue() {
            if (!VirtualMachineProxyImpl.this.myVersionHigher15) {
                return false;
            }
            try {
                Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.myVirtualMachine, new Object[0]);
            }
            catch (NoSuchMethodException method) {
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error(String.valueOf(e));
            }
            return false;
        }
    };
    private final Capability myGetSourceDebugExtension = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canGetSourceDebugExtension();
        }
    };
    private final Capability myRequestVMDeathEvent = new Capability(){

        @Override
        protected boolean calcValue() {
            return VirtualMachineProxyImpl.this.myVersionHigher14 && VirtualMachineProxyImpl.this.myVirtualMachine.canRequestVMDeathEvent();
        }
    };
    private final Capability myGetMethodReturnValues = new Capability(){

        @Override
        protected boolean calcValue() {
            if (VirtualMachineProxyImpl.this.myVersionHigher15) {
                try {
                    Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                    Boolean rv = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.myVirtualMachine, new Object[0]);
                    return rv;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return false;
        }
    };

    public VirtualMachineProxyImpl(VirtualMachine virtualMachine) {
        this.myVirtualMachine = virtualMachine;
        this.myVersionHigher15 = this.versionHigher("1.5");
        this.myVersionHigher14 = this.myVersionHigher15 || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        if (this.canBeModified()) {
            try {
                virtualMachine.allClasses();
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.info(String.valueOf(e));
            }
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    public final VirtualMachine getVirtualMachine() {
        return this.myVirtualMachine;
    }

    public ClassesByNameProvider getClassesByNameProvider() {
        return this::classesByName;
    }

    @Override
    public List<ReferenceType> classesByName(String s) {
        return this.myVirtualMachine.classesByName(s);
    }

    @Override
    public List<ReferenceType> allClasses() {
        List<ReferenceType> allClasses = this.myAllClasses;
        if (allClasses == null) {
            this.myAllClasses = allClasses = this.myVirtualMachine.allClasses();
        }
        return allClasses;
    }

    public String toString() {
        return this.myVirtualMachine.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map) {
        try {
            this.myVirtualMachine.redefineClasses(map);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        if (this.myAllThreadsDirty) {
            this.myAllThreadsDirty = false;
            for (ThreadReference threadReference : this.myVirtualMachine.allThreads()) {
                this.getThreadReferenceProxy(threadReference);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.myAllThreads.values());
    }

    public void threadStarted(ThreadReference thread) {
        this.getThreadReferenceProxy(thread);
    }

    public void threadStopped(ThreadReference thread) {
        this.myAllThreads.remove(thread);
    }

    public void suspend() {
        if (!this.canBeModified()) {
            return;
        }
        ++this.myPausePressedCount;
        this.myVirtualMachine.suspend();
        this.clearCaches();
    }

    public void resume() {
        if (!this.canBeModified()) {
            return;
        }
        if (this.myPausePressedCount > 0) {
            --this.myPausePressedCount;
        }
        this.clearCaches();
        LOG.debug("before resume VM");
        try {
            this.myVirtualMachine.resume();
        }
        catch (InternalException e) {
            LOG.info(String.valueOf(e));
        }
        LOG.debug("VM resumed");
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        return this.getVirtualMachine().topLevelThreadGroups().stream().map(this::getThreadGroupReferenceProxy).collect(Collectors.toList());
    }

    private void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl proxy = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.myThreadGroups.put(threadGroupReference, proxy);
        }
    }

    private boolean isJ2ME() {
        return VirtualMachineProxyImpl.isJ2ME(this.getVirtualMachine());
    }

    private static boolean isJ2ME(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        this.myThreadGroups.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.myVirtualMachine.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.myVirtualMachine.eventRequestManager();
    }

    @Deprecated
    public VoidValue mirrorOf() {
        return this.mirrorOfVoid();
    }

    public VoidValue mirrorOfVoid() {
        return this.myVirtualMachine.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public ByteValue mirrorOf(byte b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public CharValue mirrorOf(char c) {
        return this.myVirtualMachine.mirrorOf(c);
    }

    public ShortValue mirrorOf(short i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public IntegerValue mirrorOf(int i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public LongValue mirrorOf(long l) {
        return this.myVirtualMachine.mirrorOf(l);
    }

    public FloatValue mirrorOf(float v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public DoubleValue mirrorOf(double v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public StringReference mirrorOf(String s) {
        return this.myVirtualMachine.mirrorOf(s);
    }

    public Process process() {
        return this.myVirtualMachine.process();
    }

    public void dispose() {
        try {
            this.myVirtualMachine.dispose();
        }
        catch (UnsupportedOperationException e) {
            LOG.info(String.valueOf(e));
        }
    }

    public void exit(int i) {
        this.myVirtualMachine.exit(i);
    }

    @Override
    public final boolean canWatchFieldModification() {
        return this.myWatchFielsModification.isAvailable();
    }

    @Override
    public boolean canWatchFieldAccess() {
        return this.myWatchFieldAccess.isAvailable();
    }

    @Override
    public boolean canInvokeMethods() {
        return !this.myIsJ2ME.isAvailable();
    }

    @Override
    public boolean canGetBytecodes() {
        return this.myGetBytecodes.isAvailable();
    }

    public boolean canGetConstantPool() {
        return this.myGetConstantPool.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.myGetSyntheticAttribute.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.myGetOwnedMonitorInfo.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.myGetMonitorFrameInfo.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.myGetCurrentContendedMonitor.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.myGetMonitorInfo.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.myUseInstanceFilters.isAvailable();
    }

    public final boolean canRedefineClasses() {
        return this.myRedefineClasses.isAvailable();
    }

    public boolean canAddMethod() {
        return this.myAddMethod.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.myUnrestrictedlyRedefineClasses.isAvailable();
    }

    private boolean canPopFrames() {
        return this.myPopFrames.isAvailable();
    }

    public boolean canForceEarlyReturn() {
        return this.myForceEarlyReturn.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.myCanGetInstanceInfo.isAvailable();
    }

    public final boolean canBeModified() {
        return this.myVirtualMachine.canBeModified();
    }

    @Override
    public final boolean versionHigher(String version) {
        return this.myVirtualMachine.version().compareTo(version) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.myGetSourceDebugExtension.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.myRequestVMDeathEvent.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.myGetMethodReturnValues.isAvailable();
    }

    public String getDefaultStratum() {
        return this.myVersionHigher14 ? this.myVirtualMachine.getDefaultStratum() : null;
    }

    public String description() {
        return this.myVirtualMachine.description();
    }

    public String version() {
        return this.myVirtualMachine.version();
    }

    public String name() {
        return this.myVirtualMachine.name();
    }

    public void setDebugTraceMode(int i) {
        this.myVirtualMachine.setDebugTraceMode(i);
    }

    public ThreadReferenceProxyImpl getThreadReferenceProxy(ThreadReference thread) {
        if (thread == null) {
            return null;
        }
        return this.myAllThreads.computeIfAbsent(thread, t -> new ThreadReferenceProxyImpl(this, (ThreadReference)t));
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference group) {
        if (group == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl proxy = this.myThreadGroups.get(group);
        if (proxy == null && !this.myIsJ2ME.isAvailable()) {
            proxy = new ThreadGroupReferenceProxyImpl(this, group);
            this.myThreadGroups.put(group, proxy);
        }
        return proxy;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                ThreadReference threadReference = (ThreadReference)objectReference;
                return this.getThreadReferenceProxy(threadReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                ThreadGroupReference threadGroupReference = (ThreadGroupReference)objectReference;
                return this.getThreadGroupReferenceProxy(threadGroupReference);
            }
            ObjectReferenceProxyImpl proxy = this.myObjectReferenceProxies.get(objectReference);
            if (proxy == null) {
                if (objectReference instanceof StringReference) {
                    StringReference stringReference = (StringReference)objectReference;
                    proxy = new StringReferenceProxyImpl(this, stringReference);
                } else {
                    proxy = new ObjectReferenceProxyImpl(this, objectReference);
                }
                this.myObjectReferenceProxies.put(objectReference, proxy);
            }
            return proxy;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VirtualMachineProxyImpl)) {
            return false;
        }
        return this.myVirtualMachine.equals(((VirtualMachineProxyImpl)obj).getVirtualMachine());
    }

    public int hashCode() {
        return this.myVirtualMachine.hashCode();
    }

    public void clearCaches() {
        LOG.debug("VM cleared");
        this.myAllClasses = null;
        if (!this.myNestedClassesCache.isEmpty()) {
            this.myNestedClassesCache = new HashMap<ReferenceType, List<ReferenceType>>(this.myNestedClassesCache.size());
        }
        ++this.myTimeStamp;
    }

    @Override
    public int getCurrentTime() {
        return this.myTimeStamp;
    }

    public static boolean isCollected(ObjectReference reference) {
        try {
            return !VirtualMachineProxyImpl.isJ2ME(reference.virtualMachine()) && reference.isCollected();
        }
        catch (UnsupportedOperationException e) {
            LOG.info(String.valueOf(e));
            return false;
        }
    }

    public boolean isPausePressed() {
        return this.myPausePressedCount > 0;
    }

    public boolean isSuspended() {
        return this.allThreads().stream().anyMatch(thread -> thread.getSuspendCount() != 0);
    }

    public void logThreads() {
        if (LOG.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl thread : this.allThreads()) {
                if (thread.isCollected()) continue;
                LOG.debug("suspends " + String.valueOf(thread) + " " + thread.getSuspendCount() + " " + thread.isSuspended());
            }
        }
    }

    private static abstract class Capability {
        private ThreeState myValue = ThreeState.UNSURE;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.myValue == ThreeState.UNSURE) {
                try {
                    this.myValue = ThreeState.fromBoolean(this.calcValue());
                }
                catch (VMDisconnectedException e) {
                    LOG.info(String.valueOf(e));
                    this.myValue = ThreeState.NO;
                }
            }
            return this.myValue.toBoolean();
        }

        protected abstract boolean calcValue();
    }

    static final class JNITypeParserReflect {
        static Method typeNameToSignatureMethod;

        private JNITypeParserReflect() {
        }

        static String typeNameToSignature(String name) {
            if (typeNameToSignatureMethod != null) {
                try {
                    return (String)typeNameToSignatureMethod.invoke(null, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private static Method getDeclaredMethod(Class<?> aClass, String name, Class<?> ... parameters) {
            try {
                Method declaredMethod = aClass.getDeclaredMethod(name, parameters);
                declaredMethod.setAccessible(true);
                return declaredMethod;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        static {
            Method method = null;
            try {
                method = JNITypeParserReflect.getDeclaredMethod(Class.forName("com.sun.tools.jdi.JNITypeParser"), "typeNameToSignature", String.class);
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.valueOf(e));
            }
            typeNameToSignatureMethod = method;
            if (typeNameToSignatureMethod == null) {
                LOG.warn("Unable to find JNITypeParser.typeNameToSignature method");
            }
        }
    }
}

