/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.runner;

import java.nio.file.Path;
import java.util.Map;
import org.ballerinalang.debugadapter.config.ClientLaunchConfigHolder;
import org.ballerinalang.debugadapter.runner.BProgramRunner;

public class BSingleFileRunner
extends BProgramRunner {
    public BSingleFileRunner(ClientLaunchConfigHolder configHolder, String fileRoot) {
        super(configHolder, fileRoot);
    }

    @Override
    public Process start() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String balFilePath = this.configHolder.getSourcePath();
        processBuilder.command(this.getBallerinaCommand(balFilePath));
        Path singleFileRoot = Path.of(this.projectRoot, new String[0]).getParent();
        if (singleFileRoot != null) {
            processBuilder.directory(singleFileRoot.toFile());
        }
        Map<String, String> env = processBuilder.environment();
        env.remove("BAL_JAVA_DEBUG");
        if (this.configHolder.getEnv().isPresent()) {
            this.configHolder.getEnv().get().forEach(env::put);
        }
        if (env.containsKey("BAL_DEBUGGER_TEST") && env.containsKey("JAVA_OPTS")) {
            String javaOpts = env.get("JAVA_OPTS");
            if (javaOpts.contains("debugger-core-test.exec")) {
                javaOpts = javaOpts.replace("debugger-core-test.exec", "debugger-runtime-test.exec");
            }
            env.put("JAVA_OPTS", javaOpts);
        }
        return processBuilder.start();
    }
}

