/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import com.sun.jdi.Location;
import io.ballerina.identifier.Utils;
import org.ballerinalang.debugadapter.utils.PackageUtils;

public class LocationInfo {
    private final Location jdiLocation;
    private boolean isValid;
    private String orgName;
    private String moduleName;
    private String moduleVersion;
    private String fileName;

    LocationInfo(Location jdiLocation) {
        this.jdiLocation = jdiLocation;
        this.resolveLocation();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String orgName() {
        return this.orgName;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String moduleVersion() {
        return this.moduleVersion;
    }

    public String fileName() {
        return this.fileName;
    }

    private void resolveLocation() {
        try {
            String sourcePath = this.jdiLocation.sourcePath();
            String[] moduleParts = PackageUtils.getQModuleNameParts(sourcePath);
            this.orgName = moduleParts[0];
            this.moduleName = Utils.decodeIdentifier((String)moduleParts[1]);
            this.moduleVersion = moduleParts[2];
            this.fileName = moduleParts[3];
            this.isValid = true;
        }
        catch (Exception e) {
            this.isValid = false;
        }
    }
}

