/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.DebugVariableException;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class BTable
extends IndexedCompoundVariable {
    private int tableSize = -1;
    private final Map<String, Value> tableValues = new LinkedHashMap<String, Value>();
    private static final String FIELD_CONSTRAINT = "constraint";
    private static final String METHOD_SIZE = "size";
    private static final String METHOD_GET_ITERATOR = "getIterator";
    private static final String METHOD_HAS_NEXT = "hasNext";
    private static final String METHOD_NEXT = "next";
    private static final String METHOD_GET_VALUES = "getValues";
    private static final String ITERATOR_VALUE_PATTERN = ".*IteratorValue;$";

    public BTable(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.TABLE, value);
    }

    @Override
    public String computeValue() {
        try {
            String constrainedTypeName = this.getConstrainedTypeName();
            String tableSize = this.getTableSizeAsString();
            return String.format("table<%s> (entries = %s)", constrainedTypeName, tableSize);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public Either<Map<String, Value>, List<Value>> computeChildVariables(int start, int count) {
        try {
            if (!(this.jvmValue instanceof ObjectReference)) {
                return Either.forRight(new ArrayList());
            }
            if (count == 0) {
                count = this.getChildrenCount();
            }
            this.populateTableValues(start, count);
            return Either.forRight(this.getChildVariables(start, count));
        }
        catch (Exception ignored) {
            return Either.forRight(new ArrayList());
        }
    }

    @Override
    public int getChildrenCount() {
        return this.getTableSize();
    }

    private String getConstrainedTypeName() {
        try {
            Optional<Value> type = VariableUtils.getFieldValue(this.jvmValue, "type");
            if (type.isPresent() && VariableUtils.isTypeReferenceType(type.get())) {
                type = VariableUtils.getFieldValue(type.get(), "referredType");
            }
            if (type.isEmpty()) {
                return "unknown";
            }
            Optional<Value> constraint = VariableUtils.getFieldValue(type.get(), FIELD_CONSTRAINT);
            if (constraint.isEmpty()) {
                return "unknown";
            }
            Optional<Value> constraintTypeName = VariableUtils.getFieldValue(constraint.get(), "typeName");
            if (constraintTypeName.isEmpty()) {
                return "unknown";
            }
            return VariableUtils.getStringFrom(constraintTypeName.get());
        }
        catch (DebugVariableException e) {
            return "unknown";
        }
    }

    private int getTableSize() {
        if (this.tableSize < 0) {
            this.populateTableSize();
        }
        return this.tableSize;
    }

    private String getTableSizeAsString() {
        int tableSize = this.getTableSize();
        return tableSize >= 0 ? String.valueOf(tableSize) : "unknown";
    }

    private void populateTableSize() {
        try {
            Optional<Method> method = VariableUtils.getMethod(this.jvmValue, METHOD_SIZE);
            if (method.isEmpty()) {
                this.tableSize = -1;
                return;
            }
            Value size = VariableUtils.invokeRemoteVMMethod(this.context, this.jvmValue, method.get(), null);
            this.tableSize = ((IntegerValue)size).intValue();
        }
        catch (Exception e) {
            this.tableSize = -1;
        }
    }

    private void populateTableValues(int start, int count) throws Exception {
        int index = 0;
        Value iterator = this.getIterator();
        while (this.hasNext(iterator) && index < start + count) {
            Value next = this.nextElement(iterator);
            if (index >= start && index < start + count) {
                Value values;
                if (this.tableValues.containsKey(String.valueOf(index)) || (values = this.getValues(next)) == null) continue;
                Value value = ((ArrayReference)values).getValue(1);
                this.tableValues.put(String.valueOf(index), value);
            }
            ++index;
        }
    }

    private ArrayList<Value> getChildVariables(int start, int count) {
        ArrayList<Value> childVariables = new ArrayList<Value>();
        for (int i = start; i < start + count; ++i) {
            childVariables.add(this.tableValues.get(String.valueOf(i)));
        }
        return childVariables;
    }

    private Value getIterator() throws Exception {
        Optional<Method> getIteratorMethod = VariableUtils.getMethod(this.jvmValue, METHOD_GET_ITERATOR, ITERATOR_VALUE_PATTERN);
        if (getIteratorMethod.isEmpty()) {
            return null;
        }
        return VariableUtils.invokeRemoteVMMethod(this.context, this.jvmValue, getIteratorMethod.get(), null);
    }

    private boolean hasNext(Value iterator) throws Exception {
        Optional<Method> hasNextMethod = VariableUtils.getMethod(iterator, METHOD_HAS_NEXT);
        if (hasNextMethod.isEmpty()) {
            return false;
        }
        Value hasNext = VariableUtils.invokeRemoteVMMethod(this.context, iterator, hasNextMethod.get(), null);
        return Boolean.parseBoolean(hasNext.toString());
    }

    private Value nextElement(Value iterator) throws Exception {
        Optional<Method> nextMethod = VariableUtils.getMethod(iterator, METHOD_NEXT);
        if (nextMethod.isEmpty()) {
            return null;
        }
        return VariableUtils.invokeRemoteVMMethod(this.context, iterator, nextMethod.get(), null);
    }

    private Value getValues(Value next) throws Exception {
        Optional<Method> getValuesMethod = VariableUtils.getMethod(next, METHOD_GET_VALUES);
        if (getValuesMethod.isEmpty()) {
            return null;
        }
        return VariableUtils.invokeRemoteVMMethod(this.context, next, getValuesMethod.get(), null);
    }
}

