/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.util;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.MimeConstants;
import io.ballerina.stdlib.mime.util.MimeUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartDataSource
implements BRefValue {
    private static final Logger log = LoggerFactory.getLogger(MultipartDataSource.class);
    private Environment env;
    private BObject parentEntity;
    private String boundaryString;
    private OutputStream outputStream;
    private static final String DASH_BOUNDARY = "--";
    private static final String CRLF_POST_DASH = "\r\n--";
    private static final String CRLF_PRE_DASH = "--\r\n";
    private static final String CRLF = "\r\n";
    private static final char COLON = ':';
    private static final char SPACE = ' ';

    public MultipartDataSource(Environment env, BObject entityStruct, String boundaryString) {
        this.env = env;
        this.parentEntity = entityStruct;
        this.boundaryString = boundaryString;
    }

    public void serialize(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.serializeBodyPart(outputStream, this.boundaryString, this.parentEntity);
    }

    private void serializeBodyPart(OutputStream outputStream, String parentBoundaryString, BObject parentBodyPart) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.defaultCharset()));
        BArray childParts = parentBodyPart.getNativeData("body_parts") != null ? (BArray)parentBodyPart.getNativeData("body_parts") : null;
        try {
            if (childParts == null) {
                return;
            }
            boolean firstPart = true;
            for (int i = 0; i < childParts.size(); ++i) {
                BObject childPart = (BObject)childParts.getRefValue((long)i);
                if (firstPart) {
                    firstPart = false;
                    writer.write(DASH_BOUNDARY);
                } else {
                    writer.write(CRLF_POST_DASH);
                }
                writer.write(parentBoundaryString);
                writer.write(CRLF);
                this.checkForNestedParts(writer, childPart);
                this.writeBodyContent(outputStream, childPart);
            }
            this.writeFinalBoundaryString(writer, parentBoundaryString);
        }
        catch (IOException e) {
            log.error("Error occurred while writing body parts to outputstream", (Object)e.getMessage());
        }
    }

    private void checkForNestedParts(Writer writer, BObject childPart) throws IOException {
        BArray nestedParts;
        String childBoundaryString = null;
        if (MimeUtil.isNestedPartsAvailable(childPart)) {
            childBoundaryString = MimeUtil.getNewMultipartDelimiter();
            BObject mediaType = (BObject)childPart.get(MimeConstants.MEDIA_TYPE_FIELD);
            BMap paramMap = mediaType.get(MimeConstants.PARAMETER_MAP_FIELD) != null ? (BMap)mediaType.get(MimeConstants.PARAMETER_MAP_FIELD) : ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING));
            paramMap.put((Object)StringUtils.fromString((String)"boundary"), (Object)StringUtils.fromString((String)childBoundaryString));
            mediaType.set(MimeConstants.PARAMETER_MAP_FIELD, (Object)paramMap);
        }
        this.writeBodyPartHeaders(writer, childPart);
        if (childBoundaryString != null && (nestedParts = (BArray)childPart.getNativeData("body_parts")) != null && nestedParts.size() > 0) {
            this.serializeBodyPart(this.outputStream, childBoundaryString, childPart);
        }
    }

    private void writeBodyPartHeaders(Writer writer, BObject bodyPart) throws IOException {
        Object contentId;
        BMap<BString, Object> httpHeaders = EntityHeaderHandler.getEntityHeaderMap(bodyPart);
        String contentType = MimeUtil.getContentTypeWithParameters(bodyPart);
        EntityHeaderHandler.addHeader(bodyPart, httpHeaders, "content-type", contentType);
        String contentDisposition = MimeUtil.getContentDisposition(bodyPart);
        if (!contentDisposition.isEmpty()) {
            EntityHeaderHandler.addHeader(bodyPart, httpHeaders, "content-disposition", contentDisposition);
        }
        if ((contentId = bodyPart.get(MimeConstants.CONTENT_ID_FIELD)) != null && !contentId.toString().isEmpty()) {
            EntityHeaderHandler.addHeader(bodyPart, httpHeaders, "content-id", contentId.toString());
        }
        for (Map.Entry entry : httpHeaders.entrySet()) {
            writer.write(String.valueOf(entry.getKey()));
            writer.write(58);
            writer.write(32);
            BArray value = (BArray)entry.getValue();
            writer.write(String.valueOf(value.getBString(0L)));
            writer.write(CRLF);
        }
        writer.write(CRLF);
        writer.flush();
    }

    private void writeFinalBoundaryString(Writer writer, String boundaryString) throws IOException {
        writer.write(CRLF_POST_DASH);
        writer.write(boundaryString);
        writer.write(CRLF_PRE_DASH);
        writer.flush();
    }

    private void writeBodyContent(OutputStream outputStream, BObject bodyPart) throws IOException {
        Object messageDataSource = EntityBodyHandler.getMessageDataSource(bodyPart);
        if (messageDataSource != null) {
            if (messageDataSource instanceof BString) {
                outputStream.write(messageDataSource.toString().getBytes(Charset.defaultCharset()));
            } else {
                ((BRefValue)messageDataSource).serialize(outputStream);
            }
        } else {
            BStream byteStream = EntityBodyHandler.getByteStream(bodyPart);
            if (byteStream != null) {
                EntityBodyHandler.writeByteStreamToOutputStream(this.env, bodyPart, outputStream);
            } else {
                EntityBodyHandler.writeByteChannelToOutputStream(bodyPart, outputStream);
            }
        }
    }

    public String stringValue(BLink parent) {
        return null;
    }

    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    public Type getType() {
        return null;
    }

    public Object copy(Map<Object, Object> refs) {
        return null;
    }

    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    public BTypedesc getTypedesc() {
        return null;
    }
}

