/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.InfoMapper;
import io.ballerina.openapi.service.mapper.ResourceMapper;
import io.ballerina.openapi.service.mapper.ServersMapper;
import io.ballerina.openapi.service.mapper.ServiceMapperFactory;
import io.ballerina.openapi.service.mapper.constraint.ConstraintMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.OpenAPIExampleMapper;
import io.ballerina.openapi.service.mapper.hateoas.HateoasMapper;
import io.ballerina.openapi.service.mapper.metainfo.MetaInfoMapper;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.model.OASGenerationMetaInfo;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDeclaration;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDefinition;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import io.ballerina.openapi.service.mapper.model.ServiceDeclaration;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.type.extension.BallerinaTypeExtensioner;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ServiceToOpenAPIMapper {
    private ServiceToOpenAPIMapper() {
    }

    public static List<OASResult> generateOAS3Definition(Project project, SyntaxTree syntaxTree, SemanticModel semanticModel, String serviceName, Boolean needJson, Path inputPath) {
        return ServiceToOpenAPIMapper.generateOAS3Definition(project, syntaxTree, semanticModel, serviceName, needJson, inputPath, false);
    }

    public static List<OASResult> generateOAS3Definition(Project project, SyntaxTree syntaxTree, SemanticModel semanticModel, String serviceName, Boolean needJson, Path inputPath, Boolean ballerinaExtension) {
        HashMap<String, ServiceNode> servicesToGenerate = new HashMap<String, ServiceNode>();
        ArrayList<String> availableService = new ArrayList<String>();
        ArrayList<OpenAPIMapperDiagnostic> diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();
        ArrayList<OASResult> outputs = new ArrayList<OASResult>();
        if (MapperCommonUtils.containErrors(semanticModel.diagnostics())) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_106, new String[0]);
            diagnostics.add(error);
        } else {
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            ServiceToOpenAPIMapper.extractServiceNodes(serviceName, availableService, servicesToGenerate, modulePartNode, semanticModel);
            if (serviceName != null && servicesToGenerate.isEmpty()) {
                ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_107, serviceName, ((Object)availableService).toString());
                diagnostics.add(error);
            }
            for (Map.Entry serviceNode : servicesToGenerate.entrySet()) {
                String openApiName = MapperCommonUtils.getOpenApiFileName(syntaxTree.filePath(), (String)serviceNode.getKey(), needJson);
                OASResult oasDefinition = ServiceToOpenAPIMapper.generateOasFroServiceNode(project, openApiName, semanticModel, inputPath, (ServiceNode)serviceNode.getValue(), ballerinaExtension);
                outputs.add(oasDefinition);
            }
        }
        if (!diagnostics.isEmpty()) {
            OASResult exceptions = new OASResult(null, diagnostics);
            outputs.add(exceptions);
        }
        return outputs;
    }

    public static OASResult generateOasFroServiceNode(Project project, String openApiName, SemanticModel semanticModel, Path inputPath, ServiceNode serviceNode, Boolean ballerinaExtension) {
        OASGenerationMetaInfo.OASGenerationMetaInfoBuilder builder = new OASGenerationMetaInfo.OASGenerationMetaInfoBuilder();
        builder.setServiceNode(serviceNode).setSemanticModel(semanticModel).setOpenApiFileName(openApiName).setBallerinaFilePath(inputPath).setBallerinaExtension(ballerinaExtension).setProject(project);
        OASGenerationMetaInfo oasGenerationMetaInfo = builder.build();
        OASResult oasDefinition = ServiceToOpenAPIMapper.generateOAS(oasGenerationMetaInfo);
        oasDefinition.setServiceName(openApiName);
        return oasDefinition;
    }

    private static void extractServiceNodes(String serviceName, List<String> availableService, Map<String, ServiceNode> servicesToGenerate, ModulePartNode modulePartNode, SemanticModel semanticModel) {
        for (Node node : modulePartNode.members()) {
            TypeDefinitionNode typeDefinitionNode;
            Node descriptorNode;
            if (node instanceof ServiceDeclarationNode) {
                ServiceDeclaration service;
                Optional<Symbol> serviceSymbol;
                ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)node;
                if (!MapperCommonUtils.isHttpService(serviceNode, semanticModel) || !(serviceSymbol = (service = new ServiceDeclaration(serviceNode, semanticModel)).getSymbol(semanticModel)).isPresent() || !(serviceSymbol.get() instanceof ServiceDeclarationSymbol)) continue;
                ServiceToOpenAPIMapper.addService(serviceName, availableService, service, servicesToGenerate, serviceSymbol.get());
                continue;
            }
            if (!(node instanceof TypeDefinitionNode) || !(descriptorNode = MapperCommonUtils.getTypeDescriptor(typeDefinitionNode = (TypeDefinitionNode)node)).kind().equals((Object)SyntaxKind.OBJECT_TYPE_DESC) || !MapperCommonUtils.isHttpServiceContract(descriptorNode, semanticModel)) continue;
            ServiceContractType service = new ServiceContractType((TypeDefinitionNode)node);
            Optional<Symbol> serviceSymbol = service.getSymbol(semanticModel);
            serviceSymbol.ifPresent(symbol -> ServiceToOpenAPIMapper.addService(serviceName, availableService, service, servicesToGenerate, symbol));
        }
    }

    public static Optional<ServiceNode> getServiceNode(Node node, SemanticModel semanticModel) {
        ObjectTypeDescriptorNode serviceNode;
        TypeDefinitionNode serviceTypeNode;
        Node node2;
        ServiceDeclarationNode serviceNode2;
        if (node instanceof ServiceDeclarationNode && MapperCommonUtils.isHttpService(serviceNode2 = (ServiceDeclarationNode)node, semanticModel)) {
            return Optional.of(new ServiceDeclaration(serviceNode2, semanticModel));
        }
        if (node instanceof TypeDefinitionNode && (node2 = (serviceTypeNode = (TypeDefinitionNode)node).typeDescriptor()) instanceof ObjectTypeDescriptorNode && MapperCommonUtils.isHttpServiceContract((Node)(serviceNode = (ObjectTypeDescriptorNode)node2), semanticModel)) {
            return Optional.of(new ServiceContractType((TypeDefinitionNode)node));
        }
        return Optional.empty();
    }

    private static void addService(String serviceName, List<String> availableService, ServiceNode service, Map<String, ServiceNode> servicesToGenerate, Symbol serviceSymbol) {
        String basePath = service.absoluteResourcePath();
        Object updateServiceName = basePath;
        if (servicesToGenerate.containsKey(basePath)) {
            updateServiceName = basePath + "-" + serviceSymbol.hashCode();
        }
        if (serviceName != null) {
            availableService.add(basePath);
            if (serviceName.equals(basePath)) {
                servicesToGenerate.put((String)updateServiceName, service);
            }
        } else {
            servicesToGenerate.put((String)updateServiceName, service);
        }
    }

    public static OASResult generateOAS(OASGenerationMetaInfo oasGenerationMetaInfo) {
        Path ballerinaFilePath;
        ServiceNode serviceDefinition = oasGenerationMetaInfo.getServiceNode();
        SemanticModel semanticModel = oasGenerationMetaInfo.getSemanticModel();
        Package currentPackage = oasGenerationMetaInfo.getProject().currentPackage();
        ModuleMemberVisitor moduleMemberVisitor = ServiceToOpenAPIMapper.extractNodesFromProject(oasGenerationMetaInfo.getProject(), semanticModel);
        Set<ListenerDeclarationNode> listeners = moduleMemberVisitor.getListenerDeclarationNodes();
        Set<ServiceContractType> serviceContractTypes = moduleMemberVisitor.getServiceContractTypeNodes();
        String openApiFileName = oasGenerationMetaInfo.getOpenApiFileName();
        OASResult oasResult = InfoMapper.getOASResultWithInfo(serviceDefinition, semanticModel, openApiFileName, ballerinaFilePath = oasGenerationMetaInfo.getBallerinaFilePath());
        if (oasResult.getOpenAPI().isPresent() && oasResult.getDiagnostics().isEmpty()) {
            OpenAPI openapi = oasResult.getOpenAPI().get();
            ArrayList<OpenAPIMapperDiagnostic> diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();
            if (openapi.getPaths() == null) {
                ServiceMapperFactory serviceMapperFactory = new ServiceMapperFactory(openapi, semanticModel, moduleMemberVisitor, diagnostics, serviceDefinition, true);
                ServersMapper serversMapperImpl = serviceMapperFactory.getServersMapper(listeners, serviceDefinition);
                serversMapperImpl.setServers();
                if (diagnostics.stream().anyMatch(diagnostic -> diagnostic.getDiagnosticSeverity().equals((Object)DiagnosticSeverity.ERROR))) {
                    return new OASResult(openapi, diagnostics);
                }
                if (ServiceToOpenAPIMapper.oasAvailableViaServiceContract(serviceDefinition)) {
                    return ServiceToOpenAPIMapper.updateOasResultWithServiceContract((ServiceDeclaration)serviceDefinition, currentPackage, oasResult, semanticModel, serviceContractTypes);
                }
                ServiceToOpenAPIMapper.convertServiceToOpenAPI(serviceDefinition, serviceMapperFactory);
                ConstraintMapper constraintMapper = serviceMapperFactory.getConstraintMapper();
                constraintMapper.setConstraints();
                HateoasMapper hateoasMapper = serviceMapperFactory.getHateoasMapper();
                hateoasMapper.setOpenApiLinks(serviceDefinition, openapi);
                MetaInfoMapper metaInfoMapper = serviceMapperFactory.getMetaInfoMapper();
                metaInfoMapper.setResourceMetaData(openapi, serviceDefinition, ballerinaFilePath);
                diagnostics.addAll(metaInfoMapper.getDiagnostics());
                OpenAPIExampleMapper exampleMapper = serviceMapperFactory.getExampleMapper();
                exampleMapper.setExamples();
                if (openapi.getComponents().getSchemas().isEmpty()) {
                    openapi.setComponents(null);
                }
                Optional<ModuleID> serviceModuleId = ServiceToOpenAPIMapper.getServiceModuleId(serviceDefinition, semanticModel);
                if (oasGenerationMetaInfo.getBallerinaExtension().booleanValue() && serviceModuleId.isPresent()) {
                    BallerinaTypeExtensioner.removeCurrentModuleTypeExtensions(openapi, serviceModuleId.get());
                } else {
                    BallerinaTypeExtensioner.removeExtensions(openapi);
                }
                return new OASResult(openapi, diagnostics);
            }
            return new OASResult(openapi, oasResult.getDiagnostics());
        }
        return oasResult;
    }

    static boolean oasAvailableViaServiceContract(ServiceNode serviceNode) {
        return serviceNode.kind().equals((Object)ServiceNode.Kind.SERVICE_DECLARATION) && ((ServiceDeclaration)serviceNode).implementsServiceContract();
    }

    private static OASResult updateOasResultWithServiceContract(ServiceDeclaration serviceDeclaration, Package pkg, OASResult oasResult, SemanticModel semanticModel, Set<ServiceContractType> serviceContractTypes) {
        Optional<OpenAPI> openAPI = serviceDeclaration.getOpenAPIFromServiceContract(pkg, semanticModel, serviceContractTypes, oasResult.getDiagnostics());
        if (openAPI.isEmpty()) {
            return oasResult;
        }
        OpenAPI openApiFromServiceContract = openAPI.get();
        if (oasResult.getOpenAPI().isEmpty()) {
            oasResult.setOpenAPI(openApiFromServiceContract);
            return oasResult;
        }
        Info existingOpenAPIInfo = oasResult.getOpenAPI().get().getInfo();
        existingOpenAPIInfo.setTitle(openApiFromServiceContract.getInfo().getTitle());
        openApiFromServiceContract.setInfo(existingOpenAPIInfo);
        String basePath = ServiceToOpenAPIMapper.extractBasePath(openApiFromServiceContract);
        List existingServers = oasResult.getOpenAPI().get().getServers();
        existingServers.forEach(server -> server.setUrl(server.getUrl() + basePath));
        openApiFromServiceContract.setServers(existingServers);
        oasResult.setOpenAPI(openApiFromServiceContract);
        return oasResult;
    }

    private static String extractBasePath(OpenAPI openApiFromServiceContract) {
        List servers = openApiFromServiceContract.getServers();
        if (Objects.isNull(servers) || servers.isEmpty()) {
            return null;
        }
        String[] parts = ((Server)servers.get(0)).getUrl().split("\\{server}:\\{port}");
        return ((Server)servers.get(0)).getUrl().split("\\{server}:\\{port}").length == 2 ? parts[1] : "";
    }

    private static Optional<ModuleID> getServiceModuleId(ServiceNode serviceNode, SemanticModel semanticModel) {
        return semanticModel.symbol((Node)serviceNode.getInternalNode()).flatMap(symbol -> symbol.getModule().map(ModuleSymbol::id));
    }

    public static ModuleMemberVisitor extractNodesFromProject(Project project, SemanticModel semanticModel) {
        ModuleMemberVisitor balNodeVisitor = new ModuleMemberVisitor(semanticModel);
        project.currentPackage().moduleIds().forEach(moduleId -> {
            Module module = project.currentPackage().module(moduleId);
            module.documentIds().forEach(documentId -> {
                SyntaxTree syntaxTreeDoc = module.document(documentId).syntaxTree();
                syntaxTreeDoc.rootNode().accept((NodeVisitor)balNodeVisitor);
            });
        });
        return balNodeVisitor;
    }

    private static void convertServiceToOpenAPI(ServiceNode serviceNode, ServiceMapperFactory serviceMapperFactory) {
        NodeList<Node> functions = serviceNode.members();
        ArrayList<ResourceFunction> resources = new ArrayList<ResourceFunction>();
        for (Node function : functions) {
            SyntaxKind kind = function.kind();
            if (kind.equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)) {
                resources.add(new ResourceFunctionDefinition((FunctionDefinitionNode)function));
                continue;
            }
            if (!kind.equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION)) continue;
            resources.add(new ResourceFunctionDeclaration((MethodDeclarationNode)function));
        }
        ResourceMapper resourceMapper = serviceMapperFactory.getResourceMapper(resources);
        resourceMapper.setOperation();
    }
}

