/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.constraint;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.constraint.ConstraintAnnotation;
import io.ballerina.openapi.service.mapper.constraint.ConstraintMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConstraintMapperImpl
implements ConstraintMapper {
    private final OpenAPI openAPI;
    private final ModuleMemberVisitor moduleMemberVisitor;
    private final List<OpenAPIMapperDiagnostic> diagnostics;

    public ConstraintMapperImpl(OpenAPI openAPI, ModuleMemberVisitor moduleMemberVisitor, List<OpenAPIMapperDiagnostic> diagnostics) {
        this.openAPI = openAPI;
        this.moduleMemberVisitor = moduleMemberVisitor;
        this.diagnostics = diagnostics;
    }

    @Override
    public void setConstraints() {
        Components components = this.openAPI.getComponents();
        if (Objects.isNull(components)) {
            return;
        }
        Map schemas = components.getSchemas();
        for (Map.Entry schemaEntry : schemas.entrySet()) {
            Object object;
            Optional<TypeDefinitionNode> typeDefNodeOpt = this.moduleMemberVisitor.getTypeDefinitionNode((String)schemaEntry.getKey());
            if (typeDefNodeOpt.isEmpty()) continue;
            TypeDefinitionNode typeDefinitionNode = typeDefNodeOpt.get();
            if (typeDefinitionNode.metadata().isPresent()) {
                ConstraintAnnotation.ConstraintAnnotationBuilder constraintBuilder = new ConstraintAnnotation.ConstraintAnnotationBuilder();
                this.extractedConstraintAnnotation((MetadataNode)typeDefinitionNode.metadata().get(), constraintBuilder);
                ConstraintAnnotation constraintAnnot = constraintBuilder.build();
                this.setConstraintValueToSchema(constraintAnnot, (Schema)schemaEntry.getValue());
            }
            if (!((object = schemaEntry.getValue()) instanceof ObjectSchema)) continue;
            ObjectSchema objectSchema = (ObjectSchema)object;
            object = typeDefinitionNode.typeDescriptor();
            if (!(object instanceof RecordTypeDescriptorNode)) continue;
            RecordTypeDescriptorNode recordTypeDescriptorNode = (RecordTypeDescriptorNode)object;
            this.setObjectConstraintValuesToSchema(objectSchema, recordTypeDescriptorNode);
        }
    }

    private void setConstraintValueToSchema(ConstraintAnnotation constraintAnnot, Schema properties) {
        try {
            String schemaType;
            switch (schemaType = this.getEffectiveSchemaType(properties)) {
                case "array": {
                    this.setArrayConstraintValuesToSchema(constraintAnnot, properties);
                    break;
                }
                case "string": {
                    this.setStringConstraintValuesToSchema(constraintAnnot, properties);
                    break;
                }
                case "integer": {
                    this.setIntegerConstraintValuesToSchema(constraintAnnot, properties);
                    break;
                }
                case "number": {
                    this.setNumberConstraintValuesToSchema(constraintAnnot, properties);
                    break;
                }
            }
        }
        catch (ParseException parseException) {
            ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_114, parseException.getMessage());
            this.diagnostics.add(diagnostic);
        }
    }

    private String getEffectiveSchemaType(Schema schema) {
        Schema schemaObj;
        Map schemas;
        Components components;
        String ref;
        if (schema instanceof ArraySchema) {
            return "array";
        }
        if (schema instanceof IntegerSchema) {
            return "integer";
        }
        if (schema instanceof NumberSchema) {
            return "number";
        }
        if (schema instanceof StringSchema) {
            return "string";
        }
        if (schema instanceof ObjectSchema && Objects.nonNull(ref = schema.get$ref()) && Objects.nonNull(components = this.openAPI.getComponents()) && Objects.nonNull(schemas = components.getSchemas()) && Objects.nonNull(schemaObj = (Schema)schemas.get(ref.substring(ref.lastIndexOf(47) + 1)))) {
            return this.getEffectiveSchemaType(schemaObj);
        }
        return "object";
    }

    private void setIntegerConstraintValuesToSchema(ConstraintAnnotation constraintAnnot, Schema properties) {
        if (Objects.nonNull(properties.get$ref()) && constraintAnnot.hasConstraints()) {
            Schema refSchema = new Schema();
            refSchema.set$ref(properties.get$ref());
            properties.set$ref(null);
            properties.addAllOfItem(refSchema);
            properties.setType(null);
        }
        BigDecimal minimum = null;
        BigDecimal maximum = null;
        if (constraintAnnot.getMinValue().isPresent()) {
            minimum = BigDecimal.valueOf(Integer.parseInt(constraintAnnot.getMinValue().get()));
        } else if (constraintAnnot.getMinValueExclusive().isPresent()) {
            minimum = BigDecimal.valueOf(Integer.parseInt(constraintAnnot.getMinValueExclusive().get()));
            properties.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if (constraintAnnot.getMaxValue().isPresent()) {
            maximum = BigDecimal.valueOf(Integer.parseInt(constraintAnnot.getMaxValue().get()));
        } else if (constraintAnnot.getMaxValueExclusive().isPresent()) {
            maximum = BigDecimal.valueOf(Integer.parseInt(constraintAnnot.getMaxValueExclusive().get()));
            properties.setExclusiveMaximum(Boolean.valueOf(true));
        }
        properties.setMinimum(minimum);
        properties.setMaximum(maximum);
    }

    private void setNumberConstraintValuesToSchema(ConstraintAnnotation constraintAnnot, Schema properties) throws ParseException {
        if (Objects.nonNull(properties.get$ref()) && constraintAnnot.hasConstraints()) {
            Schema refSchema = new Schema();
            refSchema.set$ref(properties.get$ref());
            properties.set$ref(null);
            properties.addAllOfItem(refSchema);
            properties.setType(null);
        }
        BigDecimal minimum = null;
        BigDecimal maximum = null;
        if (constraintAnnot.getMinValue().isPresent()) {
            minimum = BigDecimal.valueOf(NumberFormat.getInstance().parse(constraintAnnot.getMinValue().get()).doubleValue());
        } else if (constraintAnnot.getMinValueExclusive().isPresent()) {
            minimum = BigDecimal.valueOf(NumberFormat.getInstance().parse(constraintAnnot.getMinValueExclusive().get()).doubleValue());
            properties.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if (constraintAnnot.getMaxValue().isPresent()) {
            maximum = BigDecimal.valueOf(NumberFormat.getInstance().parse(constraintAnnot.getMaxValue().get()).doubleValue());
        } else if (constraintAnnot.getMaxValueExclusive().isPresent()) {
            maximum = BigDecimal.valueOf(NumberFormat.getInstance().parse(constraintAnnot.getMaxValueExclusive().get()).doubleValue());
            properties.setExclusiveMaximum(Boolean.valueOf(true));
        }
        properties.setMinimum(minimum);
        properties.setMaximum(maximum);
    }

    private void setStringConstraintValuesToSchema(ConstraintAnnotation constraintAnnot, Schema properties) {
        if (Objects.nonNull(properties.get$ref()) && constraintAnnot.hasConstraints()) {
            Schema refSchema = new Schema();
            refSchema.set$ref(properties.get$ref());
            properties.set$ref(null);
            properties.addAllOfItem(refSchema);
            properties.setType(null);
        }
        if (constraintAnnot.getLength().isPresent()) {
            properties.setMinLength(Integer.valueOf(constraintAnnot.getLength().get()));
            properties.setMaxLength(Integer.valueOf(constraintAnnot.getLength().get()));
        } else {
            properties.setMaxLength(constraintAnnot.getMaxLength().isPresent() ? Integer.valueOf(constraintAnnot.getMaxLength().get()) : null);
            properties.setMinLength(constraintAnnot.getMinLength().isPresent() ? Integer.valueOf(constraintAnnot.getMinLength().get()) : null);
        }
        if (constraintAnnot.getPattern().isPresent()) {
            String regexPattern = constraintAnnot.getPattern().get();
            properties.setPattern(regexPattern);
        }
    }

    private void setArrayConstraintValuesToSchema(ConstraintAnnotation constraintAnnot, Schema properties) {
        if (Objects.nonNull(properties.get$ref()) && constraintAnnot.hasConstraints()) {
            Schema refSchema = new Schema();
            refSchema.set$ref(properties.get$ref());
            properties.set$ref(null);
            properties.addAllOfItem(refSchema);
            properties.setType(null);
        }
        if (constraintAnnot.getLength().isPresent()) {
            properties.setMinItems(Integer.valueOf(constraintAnnot.getLength().get()));
            properties.setMaxItems(Integer.valueOf(constraintAnnot.getLength().get()));
        } else {
            properties.setMaxItems(constraintAnnot.getMaxLength().isPresent() ? Integer.valueOf(constraintAnnot.getMaxLength().get()) : null);
            properties.setMinItems(constraintAnnot.getMinLength().isPresent() ? Integer.valueOf(constraintAnnot.getMinLength().get()) : null);
        }
    }

    private void setObjectConstraintValuesToSchema(ObjectSchema typeSchema, RecordTypeDescriptorNode recordTypeDescriptorNode) {
        NodeList fieldNodes = recordTypeDescriptorNode.fields();
        for (Node fieldNode : fieldNodes) {
            MetadataNode metadata = null;
            String fieldName = null;
            Node fieldTypeNode = null;
            if (fieldNode instanceof RecordFieldNode) {
                RecordFieldNode recordFieldNode = (RecordFieldNode)fieldNode;
                metadata = recordFieldNode.metadata().orElse(null);
                fieldName = recordFieldNode.fieldName().toString().trim();
                fieldTypeNode = recordFieldNode.typeName();
            } else if (fieldNode instanceof RecordFieldWithDefaultValueNode) {
                RecordFieldWithDefaultValueNode recordFieldNode = (RecordFieldWithDefaultValueNode)fieldNode;
                metadata = recordFieldNode.metadata().orElse(null);
                fieldName = recordFieldNode.fieldName().toString().trim();
                fieldTypeNode = recordFieldNode.typeName();
            }
            Map properties = typeSchema.getProperties();
            if (Objects.isNull(metadata)) {
                this.handleInlineRecordFieldType(fieldTypeNode, properties, fieldName);
                continue;
            }
            ConstraintAnnotation.ConstraintAnnotationBuilder constraintBuilder = new ConstraintAnnotation.ConstraintAnnotationBuilder();
            this.extractedConstraintAnnotation(metadata, constraintBuilder);
            ConstraintAnnotation constraintAnnot = constraintBuilder.build();
            if (!Objects.nonNull(properties) || !properties.containsKey(fieldName)) continue;
            this.setConstraintValueToSchema(constraintAnnot, (Schema)properties.get(fieldName));
        }
    }

    private void handleInlineRecordFieldType(Node fieldTypeNode, Map<String, Schema> properties, String fieldName) {
        if (Objects.nonNull(fieldTypeNode) && Objects.nonNull(properties) && fieldTypeNode instanceof RecordTypeDescriptorNode) {
            Schema fieldTypeSchema;
            RecordTypeDescriptorNode recordFieldTypeDescriptorNode = (RecordTypeDescriptorNode)fieldTypeNode;
            if (properties.containsKey(fieldName) && (fieldTypeSchema = properties.get(fieldName)) instanceof ObjectSchema) {
                ObjectSchema fieldTypeObjSchema = (ObjectSchema)fieldTypeSchema;
                this.setObjectConstraintValuesToSchema(fieldTypeObjSchema, recordFieldTypeDescriptorNode);
            }
        }
    }

    private void extractedConstraintAnnotation(MetadataNode metadata, ConstraintAnnotation.ConstraintAnnotationBuilder constraintBuilder) {
        NodeList annotations = metadata.annotations();
        annotations.stream().filter(this::isConstraintAnnotation).filter(annotation -> annotation.annotValue().isPresent()).forEach(annotation -> {
            if (this.isDateConstraint((AnnotationNode)annotation)) {
                ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_120, (Location)annotation.location(), annotation.toString());
                this.diagnostics.add(error);
                return;
            }
            MappingConstructorExpressionNode annotationValue = annotation.annotValue().orElse(null);
            if (Objects.isNull(annotationValue)) {
                return;
            }
            annotationValue.fields().stream().filter(field -> SyntaxKind.SPECIFIC_FIELD.equals((Object)field.kind())).forEach(field -> {
                String name = ((SpecificFieldNode)field).fieldName().toString().trim();
                this.processConstraintAnnotation((SpecificFieldNode)field, name, constraintBuilder);
            });
        });
    }

    private boolean isConstraintAnnotation(AnnotationNode annotation) {
        Node node = annotation.annotReference();
        if (node instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode qualifiedNameRef = (QualifiedNameReferenceNode)node;
            return qualifiedNameRef.modulePrefix().text().equals("constraint");
        }
        return false;
    }

    private boolean isDateConstraint(AnnotationNode annotation) {
        return annotation.annotReference().toString().trim().equals("constraint:Date");
    }

    private void processConstraintAnnotation(SpecificFieldNode specificFieldNode, String fieldName, ConstraintAnnotation.ConstraintAnnotationBuilder constraintBuilder) {
        specificFieldNode.valueExpr().flatMap(this::extractFieldValue).ifPresent(fieldValue -> this.fillConstraintValue(constraintBuilder, fieldName, (String)fieldValue));
    }

    private Optional<String> extractFieldValue(ExpressionNode exprNode) {
        SyntaxKind syntaxKind = exprNode.kind();
        switch (syntaxKind) {
            case NUMERIC_LITERAL: {
                return Optional.of(exprNode.toString().trim());
            }
            case REGEX_TEMPLATE_EXPRESSION: {
                String regexContent = ((TemplateExpressionNode)exprNode).content().get(0).toString();
                if (regexContent.matches("^(?!.*\\$\\{).+$")) {
                    return Optional.of(regexContent);
                }
                ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_119, (Location)exprNode.location(), regexContent);
                this.diagnostics.add(error);
                return Optional.empty();
            }
            case MAPPING_CONSTRUCTOR: {
                return ((MappingConstructorExpressionNode)exprNode).fields().stream().filter(fieldNode -> ((SpecificFieldNode)fieldNode).fieldName().toString().trim().equals("value")).findFirst().flatMap(node -> ((SpecificFieldNode)node).valueExpr().flatMap(this::extractFieldValue));
            }
        }
        ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_118, (Location)exprNode.location(), exprNode.toString());
        this.diagnostics.add(error);
        return Optional.empty();
    }

    private void fillConstraintValue(ConstraintAnnotation.ConstraintAnnotationBuilder constraintBuilder, String name, String constraintValue) {
        switch (name) {
            case "minValue": {
                constraintBuilder.withMinValue(constraintValue);
                break;
            }
            case "maxValue": {
                constraintBuilder.withMaxValue(constraintValue);
                break;
            }
            case "minValueExclusive": {
                constraintBuilder.withMinValueExclusive(constraintValue);
                break;
            }
            case "maxValueExclusive": {
                constraintBuilder.withMaxValueExclusive(constraintValue);
                break;
            }
            case "length": {
                constraintBuilder.withLength(constraintValue);
                break;
            }
            case "maxLength": {
                constraintBuilder.withMaxLength(constraintValue);
                break;
            }
            case "minLength": {
                constraintBuilder.withMinLength(constraintValue);
                break;
            }
            case "pattern": {
                constraintBuilder.withPattern(constraintValue);
                break;
            }
        }
    }
}

